import { useContactList } from "../../../store/api/useContactList";
import LoadingSkeletonImageDynamic from "../../../components/LoadingSkeletonImageDynamic";
import { useAppDispatch, useAppSelector } from "../../../utils/hooks";
import {
  addOrRemoveUserId,
  updateCreateGroupData,
} from "../../../store/Slices/CreateGroupSlice";
import { ClipLoader } from "react-spinners";
import { useTheme } from "../../../context/ThemeProvider";
import useApiPost from "../../../hooks/PostData";
import toast from "react-hot-toast";
import { useGroupSettings } from "../../../store/api/useGroupSettings";
import { useConversationMembers } from "../../../store/api/useConversationMembers";
import { useTranslateText } from "../../../hooks/useTranslateText";
import SearchNotFoundAnimation from "../../../components/SearchNotFoundAnimation";

export default function AddMemberContactList({
  searchUser,
}: {
  searchUser: string;
}) {
  const { theme } = useTheme();
  const { isLoading: isContactLoading, data: contactListUser } =
    useContactList();
  const CreateGroup = useAppSelector((state) => state.CreateGroup);
  const CurrentConversation = useAppSelector(
    (state) => state.CurrentConversation,
  );
  const OnlineUserList = useAppSelector((state) => state.OnlineUserList);
  const dispatch = useAppDispatch();
  const { loading, postData } = useApiPost();
  const { refetch } = useConversationMembers();
  const { data: groupSettingsData } = useGroupSettings();
  const translate = useTranslateText();

  async function addMemberToGroup() {
    // await Promise.all(
    // CreateGroup.user_id.map((single_user_id: string) =>
    await postData("chat/add-member", {
      user_id: CreateGroup.user_id,
      chat_id: CurrentConversation.chat_id,
    }),
      // ),
      // );

      dispatch(
        updateCreateGroupData({
          show_add_member_modal: false,
          existing_member_user_id: [],
          user_id: [],
        }),
      );
    toast.success(`${CreateGroup.user_id.length} ${translate("members added to group")}`);

    refetch();
  }
console.log(contactListUser?.data,"contactListUser?.data");

  return (
    <div className="my-5 flex h-[60vh] w-full max-w-full flex-col overflow-y-auto overflow-x-hidden pb-20">
      {isContactLoading && (
        <div className="flex h-[83vh] flex-col items-center justify-center gap-y-2 overflow-y-auto px-14 py-6">
          <ClipLoader color={theme == "dark" ? "white" : "black"} />
        </div>
      )}
      {contactListUser?.data?.length == 0 ? (
        <div className="grid h-96 place-content-center gap-5">
          <SearchNotFoundAnimation />
          <div>{translate("No contacts found")}</div>
        </div>
      ) : (
        contactListUser?.data
          .filter((contact) =>
            contact.name.toLowerCase().includes(searchUser.toLowerCase()),
          )
          .map((e) => {
            return (
              <>
                <div
                  onClick={() => {
                    if (
                      CreateGroup.user_id.length >=
                      Number(groupSettingsData?.settings[0].max_members) &&
                      !CreateGroup.user_id.includes(e?.user_id)
                    ) {
                      toast.error(
                        `Max group memeber size is ${groupSettingsData?.settings[0].max_members ?? 10}`,
                        { position: "bottom-left" },
                      );
                      return;
                    }

                    dispatch(
                      addOrRemoveUserId({
                        user_id: e.user_id,
                      }),
                    );
                    //   if (
                    //     currentConversationData.chat_id != e.chat_id
                    //   ) {
                    //     dispatch(updateCurrentConversation(e));
                    //     dispatch(removeMessageList());
                    //   }
                  }}
                  onContextMenu={() => {
                    //   handleBlockContextMenu(e);
                    //   setSelectedConversation(e);
                  }}
                  // if member is allready in the group then can not be removed from here
                  style={{
                    pointerEvents: CreateGroup.existing_member_user_id.includes(
                      e?.user_id,
                    )
                      ? "none"
                      : "auto",
                  }}
                  className={`flex cursor-pointer items-center justify-start px-3 py-4 hover:bg-selectedChat ${CreateGroup.user_id.includes(e?.user_id) && "bg-selectedChat"} ${CreateGroup.existing_member_user_id.includes(e?.user_id) &&
                    "opacity-70"
                    }`}
                >
                  {CreateGroup?.user_id.includes(e?.user_id) ||
                    CreateGroup?.existing_member_user_id?.includes(e?.user_id) ? (
                    <div className="ml-2 mr-4 grid h-full grid-cols-1 place-content-center gap-y-2 text-center">
                      <img
                        className="h-5 w-5"
                        src="/Home/selected_checkbox.png"
                        alt=""
                      />
                    </div>
                  ) : (
                    <div className="ml-2 mr-4 grid h-full grid-cols-1 place-content-center gap-y-2 text-center">
                      <img
                        className="h-5 w-5"
                        src="/Home/Empty_checkbox.png"
                        alt=""
                      />
                    </div>
                  )}
                  <div className="relative mr-3 h-14 w-14 2xl:h-12 2xl:w-12">
                    <LoadingSkeletonImageDynamic
                      radius=""
                      className="min-h-10 min-w-10 rounded-full object-cover 2xl:h-12 2xl:w-12"
                      image_height="100%"
                      image_url={e?.profile_pic}
                      image_width=""
                    />
                    {OnlineUserList?.onlineUsers?.find(
                      (user) => user.user_id == e?.user_id,
                    ) && (
                        <img
                          className="absolute bottom-0 right-0 z-30 h-4 w-4"
                          src="/Home/Online_Green_dot.png"
                          alt=""
                        />
                      )}
                  </div>

                  <div>
                    <div className="text-base font-medium capitalize text-darkText">
                      {e?.name}
                    </div>

                    <div className="flex items-center gap-x-1">
                      {/* <LiaCheckDoubleSolid className="text-lg text-primary" /> */}
                      <div className="line-clamp-1 flex w-full max-w-[12.5rem] gap-x-1 text-[13px] text-lightText">
                        {e?.user_name}
                      </div>
                    </div>
                  </div>
                </div>
                <hr className="border-t border-borderColor" />
              </>
            );
          })
      )}

      {CreateGroup.user_id.length !== 0 && (
        <div className="absolute bottom-0 flex h-24 w-full items-end bg-gradient-to-t from-primary to-transparent">
          <div
            onClick={() => {
              addMemberToGroup();
              // navigate("/create-group");
            }}
            className="primary-gradient mx-auto my-5 w-[90%] cursor-pointer rounded-lg py-2 text-center"
          >
            {loading ? (
              <ClipLoader
                size={19}
                color={theme == "dark" ? "white" : "black"}
              />
            ) : (
              "Add Member"
            )}
          </div>
        </div>
      )}
    </div>
  );
}
