import React from "react";
import { useAppSelector } from "../../../utils/hooks";
import TextTranslate from "../../../utils/TextTranslate";

export default function AboutConversation() {
  const currentConversationData = useAppSelector(
    (state) => state.CurrentConversation,
  );
  return (
    <>
      {currentConversationData.chat_type == "private" &&
      currentConversationData.bio != "" ? (
        <div className="flex flex-col border border-borderColor px-10 py-1">
          <div className="text-sm font-normal">
            <TextTranslate text="About" />
          </div>
          <div className="font-medium">{currentConversationData.bio}</div>
        </div>
      ) : (
        currentConversationData.chat_type == "group" &&
        currentConversationData.group_description != "" && (
          <div className="flex flex-col border border-borderColor px-10 py-1">
            <div className="text-sm font-normal">
              <TextTranslate text="Group Description" />
            </div>
            <div className="font-medium">
              {currentConversationData.group_description}
            </div>
          </div>
        )
      )}
    </>
  );
}
