/* eslint-disable prefer-const */
import LinksAndMedia from "./LinksAndMedia";
import GroupHeader from "./GroupHeader";
import GroupMembers from "./GroupMembers";
import GroupActions from "./GroupActions";
import StarMessageTab from "./StarMessageTab";
import { RxCross2 } from "react-icons/rx";
import { toggleProfileView } from "../../../store/Slices/ViewManagerSlice";
import { useAppDispatch, useAppSelector } from "../../../utils/hooks";
import TextTranslate from "../../../utils/TextTranslate";
import AboutConversation from "./AboutConversation";

export default function GroupInfo() {
  const currentConversationData = useAppSelector(
    (state) => state.CurrentConversation,
  );
  let dispatch = useAppDispatch();
  return (
    <>
      <div className="absolute z-10 flex text-themeTextColor w-full items-center gap-3 bg-no-repeat px-3 py-4 font-semibold text-darkText backdrop-blur-lg">
        <RxCross2
          className="cursor-pointer text-2xl"
          onClick={() => {
            dispatch(toggleProfileView(false));
          }}
        />
        <span className="">
          <TextTranslate
            text={
              currentConversationData.chat_type == "group"
                ? "Group Info"
                : "Contact Info"
            }
          />
        </span>
      </div>

      <div className="flex w-full min-w-72 flex-col overflow-auto overflow-x-hidden bg-secondary shadow-inner 2xl:min-w-96">
        <GroupHeader />
        <div className="h-96 lg:h-auto pb-16 overflow-auto space-y-3">
          {/* About */}
          <AboutConversation />

          {/* Links And Media */}
          <LinksAndMedia />

          {/* Star Message */}
          <StarMessageTab />

          {/* Group Members */}
          <GroupMembers />

          {/* Group Actions */}
          <GroupActions />
        </div>
      </div>
    </>
  );
}
