import LoadingSkeletonImageDynamic from "../../../../components/LoadingSkeletonImageDynamic";
import { useAppDispatch, useAppSelector } from "../../../../utils/hooks";
import {
  updateForwardedList,
  updateForwardedUserId,
} from "../../../../store/Slices/ForwardMessageSlice";
import { IoIosCheckmarkCircle } from "react-icons/io";
import { GiCircle } from "react-icons/gi";
import { ContactType } from "../../../../types/ResType";
import { OuterChat } from "../../../../types/ChatListType";

export default function ForwardMessageConversationsList({
  searchUser,
}: {
  searchUser: string;
  handleCloseModal: () => void;
}) {
  const ChatListArray = useAppSelector((state) => state.chatList);

  const ForwardMessageData = useAppSelector((state) => state.ForwardMessage);
  const ContactList = useAppSelector((state) => state.ContactList);
  const forwarded_user_ids = useAppSelector(
    (state) => state.ForwardMessage.forwarded_user_id,
  );
  const OnlineUserList = useAppSelector((state) => state.OnlineUserList);
  const dispatch = useAppDispatch();

  function selectChat(chat: OuterChat) {
    if (chat.Records[0].chat_type == "group") {
      dispatch(
        updateForwardedList({
          chat_id: chat.Records[0].chat_id,
        }),
      );
    } else {
      dispatch(
        updateForwardedUserId({
          user_id: chat.PeerUserData.user_id,
        }),
      );
    }
  }

  return (
    <div className="flex h-[60vh] w-full max-w-full flex-col overflow-y-auto pb-10 overflow-x-hidden">
      {ChatListArray?.Chats?.filter((conversations) => {
        const record = conversations.Records[0];

        // Exclude blocked contacts
        if (record.blocked_by.length > 0) return false;

        // Apply search filter
        return (
          record.group_name.toLowerCase().includes(searchUser.toLowerCase()) ||
          conversations.PeerUserData.full_name
            .toLowerCase()
            .includes(searchUser.toLowerCase())
        );
      }).map((e) => {
        return (
          <>
            <div
              onClick={() => {
                selectChat(e);
              }}
              className={`flex cursor-pointer items-center justify-start px-3 py-4 hover:bg-selectedChat`}
            >
              <div className="relative mr-3 ">
                <LoadingSkeletonImageDynamic
                  radius=""
                  className="min-h-10 min-w-10 rounded-full object-cover 2xl:min-h-12 2xl:min-w-12"
                  image_height="100%"
                  image_url={
                    e.Records[0].chat_type == "group"
                      ? e.Records[0].group_icon
                      : e.PeerUserData.profile_pic
                  }
                  image_width=""
                />
                {OnlineUserList.onlineUsers.find(
                  (user) => user.user_id == e?.PeerUserData.user_id,
                ) && (
                    <img
                      className="absolute bottom-0 right-0 z-30 h-4 w-4"
                      src="/Home/Online_Green_dot.png"
                      alt=""
                    />
                  )}
              </div>

              <div>
                <div className="max-w-40 truncate text-base font-medium capitalize text-darkText">
                  {e.Records[0].chat_type == "group"
                    ? e.Records[0].group_name
                    : (ContactList?.data?.find(
                      (contact: ContactType) =>
                        contact?.user_id == e.PeerUserData.user_id,
                    )?.name ?? e.PeerUserData.full_name)}
                </div>

                {/* <div className="flex items-center gap-x-1">
                    <div className="line-clamp-1 flex w-full max-w-[12.5rem] gap-x-1 text-[13px] text-lightText">
                      {e.is_group ? e.group_name : e.user_name}
                    </div>
                  </div> */}
              </div>

              <button className={`relative ml-auto overflow-hidden`}>
                {ForwardMessageData.forwarded_conversations_id.includes(
                  e.Records[0].chat_id,
                ) ||
                  (e.Records[0].chat_type == "private" &&
                    forwarded_user_ids.includes(e.PeerUserData.user_id)) ? (
                  <IoIosCheckmarkCircle className="h-6 w-6 text-themeColor" />
                ) : (
                  <GiCircle className="h-6 w-6 " />
                )}
              </button>
            </div>
            <hr className="border-t border-borderColor" />
          </>
        );
      })}
    </div>
  );
}
