// import ConversationList from "./ConversationList";
import { FaChevronLeft, FaPlus } from "react-icons/fa6";
import { useLocation, useNavigate } from "react-router-dom";
import { GoDotFill } from "react-icons/go";
import ReusableProfileCard from "../Profile/ReusableProfileCard"; // Adjust the import path accordingly
import { BsInfoCircle } from "react-icons/bs";
import {
  MdOutlineColorLens,
  MdOutlinePrivacyTip,
  MdOutlineStarBorderPurple500,
} from "react-icons/md";
import { RxShare2 } from "react-icons/rx";
import { RiExchangeDollarFill, RiUserUnfollowLine } from "react-icons/ri";
import { HiOutlineLogout } from "react-icons/hi";
import LogoutModal from "./LogOutModal";
import { useState } from "react";
import { useAppDispatch, useAppSelector } from "../../../utils/hooks";
import { updateMessageOptions } from "../../../store/Slices/MessageOptionsSlice";
import { updateViewState } from "../../../store/Slices/ViewManagerSlice";
import BlockUserListModal from "./BlockUserListModal";
import { SiGnuprivacyguard } from "react-icons/si";
import { RWebShare } from "react-web-share";
import { CiLock } from "react-icons/ci";
import TextTranslate from "../../../utils/TextTranslate";
import { useTranslateText } from "../../../hooks/useTranslateText";
import { HiLanguage } from "react-icons/hi2";
import ThemeToggleFromSettings from "../ThemeToggleFromSettings";
import SubscriptionModal from "./SubscriptionModal";
import DeleteAccountModal from "./DeleteAccountModal";
import { IoNotificationsOutline } from "react-icons/io5";

export default function Setting() {
  const navigate = useNavigate();
  const [showLogOutModal, setShowLogOutModal] = useState(false);
  const userData = useAppSelector((state) => state.userData);
  const translate = useTranslateText();

  const dispatch = useAppDispatch();
  const handleValueChange = (newValue: string) => {
    // Handle the updated value here
    console.log(newValue);
  };

  const LanguageTextList = useAppSelector((state) => state.LanguageTextList);

  function translateTextFunc(text: string) {
    if (!LanguageTextList || !LanguageTextList.results) {
      return <>{text}</>; // Return the original text if no translations are available
    }

    const results = LanguageTextList.results;
    const translation = results.find((element: any) => element.key === text);
    if (translation) {
      return translation.Translation;
    } else {
      return text;
    }
  }

  return (
    <>
      <BlockUserListModal />
      <SubscriptionModal />
      <div className="flex h-screen w-full min-w-80 max-w-md flex-col overflow-auto bg-secondary pb-36 shadow-inner lg:pb-0 2xl:min-w-96">
        <div
          className="relative w-full space-y-5 bg-no-repeat px-4 xl:space-y-5"
          style={{
            backgroundImage: "url('/Home/profile_bg.png')",
            backgroundSize: "100%",
            backgroundPosition: "top",
            // This maintains the aspect ratio of the background image
            aspectRatio: "375 / 200", // Adjust this ratio based on your actual image dimensions
            minHeight: "350px", // Set a minimum height
          }}
        >
          {/* Theme tint layer (preserves transparency) */}
          <div
            className="absolute inset-0"
            style={{
              background: "var(--theme-color)",
              maskImage: "url('/Home/profile_bg.png')",
              WebkitMaskImage: "url('/Home/profile_bg.png')",
              maskSize: "100%",
              WebkitMaskSize: "100%",
              maskRepeat: "no-repeat",
              WebkitMaskRepeat: "no-repeat",
              maskPosition: "top",
              WebkitMaskPosition: "top",
              opacity: 1,
              pointerEvents: "none",
            }}
          ></div>

          {/* Content on top */}
          <div className="relative z-10 flex items-center gap-3 pt-6 font-semibold text-themeTextColor lg:pt-10 2xl:pt-10">
            <FaChevronLeft
              className="cursor-pointer"
              onClick={() => navigate(-1)}
            />
            <span>
              <TextTranslate text="Settings" />
            </span>
          </div>

          {/* Profile Image */}
          <div className="relative z-10 mx-auto h-fit w-fit pt-16 lg:pt-3">
            <img
              src={userData.profile_pic}
              className="mx-auto h-32 w-32 rounded-full bg-secondary object-cover p-2"
              alt=""
            />
            <div
              onClick={() =>
                dispatch(updateViewState({ showChangeProfileModal: true }))
              }
              className="absolute bottom-1 right-2 z-20 grid h-8 w-8 cursor-pointer place-content-center rounded-full bg-primary"
            >
              <FaPlus className="primary-gradient rounded-full p-1 text-xl" />
            </div>
          </div>

          {/* Name + Status */}
          <div className="relative z-10 space-y-2 text-center">
            <span className="text-xl font-semibold capitalize">
              {userData.full_name}
            </span>
            <div className="mx-auto flex w-fit items-center justify-center gap-2 rounded-xl bg-primary px-2 py-1 shadow-2xl">
              <GoDotFill className="text-[#2AAC7A]" />
              <TextTranslate text="Online" />
            </div>
          </div>
        </div>

        {/* Starred messages,blocked contacts */}

        <div className="mt-10 flex flex-col gap-4 space-y-3 px-4">
          {/* User Bio ====================================================================================*/}
          <ReusableProfileCard
            onClick={() => {
              dispatch(
                updateMessageOptions({
                  show_select_about_modal: true,
                }),
              );
            }}
            icon={<BsInfoCircle className="text-lg" />}
            value={userData.bio}
            onChange={handleValueChange}
            isDisabled={true}
          />
          {/* Change Theme ====================================================================================*/}
          <div
            onClick={() => {
              dispatch(
                updateViewState({
                  show_select_theme_modal: true,
                }),
              );
            }}
          >
            <ReusableProfileCard
              icon={<MdOutlineColorLens className="text-xl" />}
              value={translate("Change Theme")}
              onChange={handleValueChange}
              isDisabled={true}
            />
          </div>
          {/* Starred Messages ====================================================================================*/}
          <div
            onClick={() => {
              dispatch(updateMessageOptions({ show_all_star_messages: true }));
              navigate("/star-messages");
            }}
          >
            <ReusableProfileCard
              icon={<MdOutlineStarBorderPurple500 className="text-xl" />}
              value={translate("Starred Messages")}
              onChange={handleValueChange}
              isDisabled={true}
            />
          </div>

          {/* Block Contacts ====================================================================================*/}
          <div
            onClick={() => {
              dispatch(updateViewState({ showBlockUserList: true }));
            }}
          >
            <ReusableProfileCard
              icon={<RiUserUnfollowLine className="text-xl" />}
              value={translate("Block Contacts")}
              onChange={handleValueChange}
              isDisabled={true}
            />
          </div>

          {/* Subscription ====================================================================================*/}
          {/* <div
            onClick={() => {
              dispatch(
                updateViewState({
                  showSubscription: true,
                }),
              );
            }}
          >
            <ReusableProfileCard
              icon={<RiExchangeDollarFill className="text-2xl" />}
              value={translate("Subscription")}
              onChange={handleValueChange}
              isDisabled={true}
            />
          </div> */}
          {/* Privacy Policy ====================================================================================*/}
          <div
            onClick={() => {
              dispatch(
                updateViewState({
                  showPrivacyPolicy: true,
                  showTermsAndCondition: false,
                }),
              );
            }}
          >
            <ReusableProfileCard
              icon={<CiLock className="text-2xl" />}
              value={translate("Privacy Policy")}
              onChange={handleValueChange}
              isDisabled={true}
            />
          </div>

          {/* Terms & Condition ====================================================================================*/}
          <div
            onClick={() => {
              dispatch(
                updateViewState({
                  showTermsAndCondition: true,
                  showPrivacyPolicy: false,
                }),
              );
            }}
          >
            <ReusableProfileCard
              icon={<MdOutlinePrivacyTip className="text-xl" />}
              value={translate("Terms & Conditions")}
              onChange={handleValueChange}
              isDisabled={true}
            />
          </div>

          {/* Share a link ====================================================================================*/}
          <RWebShare
            data={{
              text: "Whoxa Chat",
              url: `${window.location.origin}`,
              title: "Whoxa Chat",
            }}
          >
            <ReusableProfileCard
              icon={<RxShare2 className="text-lg" />}
              value={translate("Share a link")}
              onChange={handleValueChange}
              isDisabled={true}
            />
          </RWebShare>

          {/* Language ====================================================================================*/}
          <div
            onClick={() => {
              dispatch(
                updateViewState({
                  show_select_language_modal: true,
                }),
              );
            }}
          >
            <ReusableProfileCard
              icon={<HiLanguage className="text-xl" />}
              value={translate("Language")}
              onChange={handleValueChange}
              isDisabled={true}
            />
          </div>
          {/* Notification ====================================================================================*/}
          {/* <div
            onClick={() => {
              dispatch(
                updateViewState({
                  show_notification_modal: true,
                }),
              );
            }}
          >
            <ReusableProfileCard
              icon={<IoNotificationsOutline className="text-xl" />}
              value={translate("Notification")}
              onChange={handleValueChange}
              isDisabled={true}
            />
          </div> */}

          {/* toggle form settings  ===================================================================================*/}
          <ThemeToggleFromSettings />

          {/* Logout ====================================================================================*/}
          <div
            onClick={() => {
              setShowLogOutModal(true);
            }}
            className="text-[#FF2525]"
          >
            <ReusableProfileCard
              icon={<HiOutlineLogout className="rotate-180 text-xl" />}
              value={translateTextFunc("Logout")}
              onChange={handleValueChange}
              hideRightArrow={true}
              isDisabled={true}
            />

            <LogoutModal
              isOpen={showLogOutModal}
              setIsOpen={setShowLogOutModal}
            />
          </div>
        </div>

        <DeleteAccountModal />
        <button
          onClick={() => {
            dispatch(updateViewState({ showDeleteAccountModal: true }));
          }}
          className="primary-gradient mx-auto my-7 w-[90%] rounded-xl py-2 font-medium shadow-xl"
        >
          Delete Account
        </button>
        <div className=" text-center font-semibold">
          <TextTranslate text="Version" /> 1.0.0
        </div>
      </div>
    </>
  );
}
