import SearchNotFoundAnimation from "../../../components/SearchNotFoundAnimation";
import { formatRelativeTime } from "../../../utils/formatUTCtoLocalDate";
import { useAppSelector } from "../../../utils/hooks";
import StatusProfile from "./StatusProfile";

export default function ViewedStatusList() {
  const statusData = useAppSelector((state) => state.status);
  const userData = useAppSelector((state) => state.userData);

  return (
    <>
      <div className="my-3 flex w-full flex-col overflow-y-auto overflow-x-hidden px-4">
        {statusData?.data?.viewed_stories?.filter((item) => item.user_id !== userData.user_id).length == 0 ? (
          <div className="grid h-96 place-content-center text-center gap-5">
            {/* <img
              className="mx-auto h-16 w-16"
              src="/LightIcons/no_search_result_found.png"
              alt=""
            /> */}
            <SearchNotFoundAnimation />
            <div>No Status Found</div>
          </div>
        ) : (
          statusData?.data?.viewed_stories?.filter((item) => item.user_id !== userData.user_id).map((item, idx) => (
            <>
              <StatusProfile
                name={item.full_name}
                profile_url={item.profile_pic}
                time={formatRelativeTime(item.updatedAt)}
                currentStatusId={item.stories[0].story_id}
              />
              <hr className="border-t border-borderColor" />
            </>
          ))
        )}
      </div>
    </>
  );
}
