import React, { useEffect } from "react";
import { useTheme } from "../../context/ThemeProvider";
import sun from "/DarkIcons/sun.png";
import moon from "/LightIcons/moon.png";

const ThemeToggleButton = () => {
  const { theme, toggleTheme } = useTheme();

  return (
    <button className="flex items-center gap-2" onClick={toggleTheme}>
      {theme === "light" ? (
        <img className="h-7" src={moon} alt="" />
      ) : (
        <img className="h-7" src={sun} alt="" />
      )}
    </button>
  );
};

export default ThemeToggleButton;
