/* eslint-disable @typescript-eslint/ban-ts-comment */
import { createSlice, PayloadAction } from "@reduxjs/toolkit";
import { ReceivingCallRes } from "../../types/ResType";

// @ts-ignore
const initialState: ReceivingCallRes = {};

// Create a slice of the state
const CallDataSlice = createSlice({
  name: "CallData",
  initialState,
  reducers: {
    updateCallData(state, action: PayloadAction<ReceivingCallRes>) {
      return action.payload;
    },
    resetCallData(state) {
      return {};
    },
  },
});

// Export the reducer and actions
export default CallDataSlice.reducer;
export const { updateCallData, resetCallData } = CallDataSlice.actions;
