import { createSlice, PayloadAction } from "@reduxjs/toolkit";
import { GroupMemberRecord } from "../../types/ResType";

const initialState: GroupMemberRecord = {
  participant_id: 0,
  is_admin: false,
  update_counter: false,
  is_deleted: false,
  last_message_id: 0,
  is_creator: false,
  createdAt: new Date(),
  updatedAt: new Date(),
  chat_id: 0,
  user_id: 0,
  User: {
    user_name: "",
    email: "",
    profile_pic: "",
    user_id: 0,
    full_name: "",
    country_code: "",
    country: "",
  }
};

// Create a slice of the state
const SelectedGroupMemberSlice = createSlice({
  name: "SelectedGroupMember",
  initialState,
  reducers: {
    // Reducer to update the MessageList
    updateSelectedGroupMember(
      state,
      action: PayloadAction<Partial<GroupMemberRecord>>,
    ) {
      // console.log("action.payload", action.payload);
      // Directly modify the state to replace the chatList
      return { ...state, ...action.payload };
    },
  },
});

// Export the reducer and actions
export default SelectedGroupMemberSlice.reducer;

export const { updateSelectedGroupMember } = SelectedGroupMemberSlice.actions;
