import { createSlice, PayloadAction } from "@reduxjs/toolkit";
import { UserData } from "../../types/UserDataType";

const initialState: UserData = {
  user_name: "",
  email: "",
  mobile_num: "",
  profile_pic: "",
  selfie: "",
  dob: "",
  user_id: 0,
  first_name: "",
  last_name: "",
  full_name: "",
  country_code: "",
  socket_ids: [],
  otp: 0,
  password: "",
  login_type: "",
  gender: "",
  country: "",
  country_short_name: "",
  state: "",
  city: "",
  bio: "",
  device_token: "",
  profile_verification_status: false,
  login_verification_status: false,
  is_private: false,
  is_admin: false,
  platforms: [],
  deleted_at: null,
  bloked_by_admin: false,
  contact_details: [],
  createdAt: new Date(),
  updatedAt: new Date(),
  avatar_path: "",
};

const UserSlice = createSlice({
  name: "userData",
  initialState,
  reducers: {
    updateSpesificUserData(state, action: PayloadAction<Partial<UserData>>) {
      // console.log("action.payload", action.payload);
      return { ...state, ...action.payload };
    },
    updateUserData(state, action: PayloadAction<UserData>) {
      // console.log("action.payload", action.payload);
      return action.payload;
    },
  },
});

export default UserSlice.reducer;
export const { updateSpesificUserData, updateUserData } = UserSlice.actions;
