import { useQuery } from "react-query";
import axios from "axios";
import Cookies from "js-cookie";
import { FetchUserRes } from "../../types/ResType";

export const useFetchAllUsers = () => {
  const token = Cookies.get("whoxa_web_token");

  return useQuery<FetchUserRes, Error>(
    ["users/find-user"],
    async () => {
      const response = await axios.post<FetchUserRes>(
        `${import.meta.env.VITE_API_URL}users/find-user`,
        {},
        {
          headers: {
            Authorization: `Bearer ${token}`,
          },
        },
      );

      return response.data;
    },
    {
      // Set cache time to prevent re-fetching on route changes
      staleTime: Infinity, // Data will never be considered stale
      cacheTime: Infinity, // Data will never be removed from cache
    },
  );
};
