export interface SingleMessageRes {
  Records: Record[];
  Pagination: Pagination;
}

export interface Pagination {
  total_pages: number;
  total_records: number;
  current_page: number;
  records_per_page: number;
}

export interface Record {
  message_content: string;
  message_thumbnail: string;
  reply_to: number;
  social_id: number;
  message_id: number;
  message_type: string;
  message_length: string;
  message_seen_status: "seen" | "sent";
  message_size: string;
  deleted_for: any[];
  starred_for: any[];
  deleted_for_everyone: boolean;
  pinned: boolean;
  pin_lifetime: null;
  peer_user: null;
  pinned_till: null;
  forwarded_from: number;
  createdAt: Date;
  updatedAt: Date;
  chat_id: number;
  sender_id: number;
  ParentMessage: null;
  Replies: any[];
  User: User;
  Chat: Chat;
  peerUserData: PeerUserData;
  unseen_count: number;
}

export interface Chat {
  group_icon: string;
  chat_id: number;
  chat_type: string;
  group_name: string;
  group_description: string;
  deleted_at: null;
  is_group_blocked: boolean;
  archived_for: string[];
  createdAt: Date;
  updatedAt: Date;
  deletedAt: null;
}

export interface User {
  user_name: string;
  email: string;
  profile_pic: string;
  user_id: number;
  full_name: string;
  country_code: string;
  country: string;
  gender: Gender;
  bio: string;
  profile_verification_status: boolean;
  login_verification_status: boolean;
  socket_ids: string[];
}
export enum Gender {
  GenderMale = "male",
  Male = "Male",
}
export interface PeerUserData {
  user_name: string;
  email: string;
  mobile_num: string;
  profile_pic: string;
  dob: string;
  user_id: number;
  first_name: string;
  last_name: string;
  full_name: string;
  country_code: string;
  socket_ids: any[];
  login_type: string;
  gender: Gender;
  country: string;
  country_short_name: string;
  state: string;
  city: string;
  bio: string;
  profile_verification_status: boolean;
  login_verification_status: boolean;
  is_private: boolean;
  is_admin: boolean;
  platforms: "android"[];
  deleted_at: null;
  bloked_by_admin: boolean;
  contact_details: ContactDetail[];
  createdAt: Date;
  updatedAt: Date;
}

export interface ContactDetail {
  name: string;
  number: string;
  user_id: number;
}
