export interface StoryListRes {
    status: boolean;
    data: Data;
    message: string;
    toast: boolean;
}

export interface Data {
    my_stories: MyStory[];
    recent_stories: RecentStory[];
    viewed_stories: RecentStory[];
}

export interface MyStory {
    media: string;
    thumbnail?: string;
    story_id: number;
    caption: string;
    story_type: string;
    expiresAt?: Date;
    tagged: any[];
    views: any[];
    is_expired?: boolean;
    createdAt: Date;
    updatedAt: Date;
    user_id: number;
}

export interface RecentStory {
    user_name: string;
    email: string;
    mobile_num: string;
    profile_pic: string;
    dob: string;
    user_id: number;
    first_name: string;
    last_name: string;
    full_name: string;
    country_code: string;
    socket_ids: string[];
    login_type: string;
    gender: string;
    country: string;
    country_short_name: string;
    state: string;
    city: string;
    bio: string;
    profile_verification_status: boolean;
    login_verification_status: boolean;
    is_private: boolean;
    is_admin: boolean;
    platforms: string[];
    ip_address: string[];
    deleted_at: null;
    blocked_by_admin: boolean;
    viewed_by_admin: boolean;
    total_media_limit: string;
    used_media_limit: string;
    available_media_limit: string;
    user_type: string;
    createdAt: Date;
    updatedAt: Date;
    stories: Story[];
    storyCount: number;
    viewedCount: number;
}


export interface StatusViewesList {
    mobile_num: string;
    profile_pic: string;
    user_id: number;
    first_name: string;
    last_name: string;
    full_name: string;
}


// StoryDetailsRes ====================================
export interface StoryDetailsRes {
    status: boolean;
    data: StoryData;
    message: string;
    toast: boolean;
}

export interface StoryData {
    story_id: number;
    caption: string;
    media: string;
    thumbnail: string;
    story_type: string;
    expiresAt: Date;
    tagged: any[];
    views: View[];
    is_expired: boolean;
    createdAt: Date;
    updatedAt: Date;
    user_id: number;
}

export interface View {
    user_id: number;
    first_name: string;
    last_name: string;
    user_name: string;
    full_name: string;
    email: null;
    country_code: string;
    socket_ids: any[];
    mobile_num: string;
    otp: number;
    password: string;
    login_type: string;
    profile_pic: string;
    selfie: string;
    dob: null;
    gender: string;
    country: string;
    country_short_name: string;
    state: string;
    city: string;
    bio: string;
    device_token: string;
    profile_verification_status: boolean;
    login_verification_status: boolean;
    is_private: boolean;
    is_admin: boolean;
    platforms: string[];
    ip_address: string[];
    deleted_at: null;
    blocked_by_admin: boolean;
    viewed_by_admin: boolean;
    contact_details: ContactDetail[];
    total_media_limit: string;
    used_media_limit: string;
    available_media_limit: string;
    user_type: string;
    createdAt: Date;
    updatedAt: Date;
}

export interface ContactDetail {
    name: string;
    number: string;
    user_id: number;
}

