import { useAppSelector } from "./hooks";

const TextTranslate: React.FC<{ text: string }> = ({ text }) => {
  const LanguageTextList = useAppSelector((state) => state.LanguageTextList);

  if (!LanguageTextList || !LanguageTextList?.data?.Records) {
    return <>{text}</>; // Return the original text if no translations are available
  }

  const results = LanguageTextList?.data?.Records;
  const translation = results.find((element) => element.key == text);

  return <>{translation ? translation.Translation : text}</>; // Show translated text or original
};

export default TextTranslate;
