const changeFavicon = (url: string) => {
  const link =
    document.querySelector("link[rel*='icon']") ||
    document.createElement("link");
  link.type = "image/png"; // or "image/jpeg" for .jpg
  link.rel = "icon";
  link.href = url;
  document.getElementsByTagName("head")[0].appendChild(link);
};
function changeThemeColor(color: string) {
  let metaThemeColor = document.querySelector("meta[name='theme-color']");

  if (!metaThemeColor) {
    metaThemeColor = document.createElement("meta");
    metaThemeColor.setAttribute("name", "theme-color");
    document.head.appendChild(metaThemeColor);
  }

  metaThemeColor.setAttribute("content", color);
}

export { changeFavicon, changeThemeColor };
