import { useTheme } from "../context/ThemeProvider";
import { useWebsiteSettings } from "../store/api/useWebsiteSettings";

export default function AdminBlockedYou() {
  const { data: websiteSettings } = useWebsiteSettings();
  const { theme } = useTheme();

  return (
    <div className="grid h-screen w-full place-content-center text-center">
      <img
        src={`${theme === "dark" ? websiteSettings?.data.web_logo_dark : websiteSettings?.data.web_logo_light}`}
        className="mx-auto mb-10 h-24 w-24 object-contain"
        alt=""
      />
      <div className="text-2xl">
        You are blocked by {websiteSettings?.data.app_name} Admin.
      </div>
    </div>
  );
}
