import { useAppSelector } from "../utils/hooks";
import { ContactType } from "../types/ResType";

export function useContactName({
  user_id,
  fallbackName,
}: {
  user_id: string;
  fallbackName: string;
}) {
  const ContactList = useAppSelector((state) => state.ContactList);

  const name =
    ContactList?.data?.find(
      (e: ContactType) => e?.user_id.toString() === user_id,
    )?.name ?? fallbackName;

  return name;
}
