import { useAppSelector } from "../utils/hooks";

export function useTranslateText() {
  const LanguageTextList = useAppSelector((state) => state.LanguageTextList);

  return (text: string): string => {
    if (!LanguageTextList || !LanguageTextList?.data?.Records) {
      return text; // Return the original text if no translations are available
    }

    const results = LanguageTextList.data.Records;
    const translation = results.find((element) => element.key === text);

    return translation ? translation.Translation! : text; // Return translated text or original
  };
}
