import { CallRecord } from "../../../types/CallHistoryRes";
import { useAppSelector } from "../../../utils/hooks";

interface CallInCallHistoryProps {
  callData: CallRecord;
}

export default function CallInCallHistory({
  callData,
}: CallInCallHistoryProps) {
  const userData = useAppSelector((state) => state.userData);

  const call = callData?.Calls?.[0];
  if (!call) return null;

  const isVideo = call.call_type === "video";
  const isMissed = call.call_status === "missed";
  const isOutgoing = call.caller?.user_id === userData.user_id;

  // --- Icon path ---
  let iconSrc = "";
  if (isMissed) {
    iconSrc = isVideo
      ? "/CallIcons/missed_video_call.png"
      : "/CallIcons/missed_audio_call.png";
  } else {
    iconSrc = isVideo
      ? isOutgoing
        ? "/CallIcons/outgoing_video_call.png"
        : "/CallIcons/incoming_video_call.png"
      : isOutgoing
        ? "/CallIcons/outgoing_audio_call.png"
        : "/CallIcons/incoming_audio_call.png";
  }

  // --- Label ---
  let label = "";
  if (isMissed) {
    label = isVideo ? "Missed Video Call" : "Missed Audio Call";
  } else {
    label = isVideo
      ? isOutgoing
        ? "Outgoing Video Call"
        : "Incoming Video Call"
      : isOutgoing
        ? "Outgoing Audio Call"
        : "Incoming Audio Call";
  }

  return (
    <div className="flex items-center gap-0 text-xs text-darkText">
      <div className="grid h-6 w-6 place-content-center rounded-full">
        <img src={iconSrc} className="h-4 w-4 object-contain" alt="" />
      </div>
      <div>{label}</div>
    </div>
  );
}
