import LoadingSkeletonImageDynamic from "../../../components/LoadingSkeletonImageDynamic";
import { ClipLoader } from "react-spinners";
import { useTheme } from "../../../context/ThemeProvider";
import { useCallHistory } from "../../../store/api/useCallHistory";
import CallInCallHistory from "./CallInCallHistory";
import { formatDate, formatTime } from "../../../utils/formatUTCtoLocalDate";
import ShowSavedName from "../../../components/ShowSavedName";
import SearchNotFoundAnimation from "../../../components/SearchNotFoundAnimation";

export default function MissedCallHistory() {
  const { data: callHistory, isLoading } = useCallHistory();
  const { theme } = useTheme();

  // Extract records for cleaner logic
  const records = callHistory?.data?.Records || [];

  // Filter only missed calls that have valid Calls
  const missedCalls = records.filter(
    (record) =>
      record?.Calls?.length > 0 && record.Calls[0]?.call_status === "missed"
  );

  // Loading state
  if (isLoading) {
    return (
      <div className="flex h-[75vh] w-full items-center justify-center">
        <ClipLoader size={23} color={theme === "dark" ? "white" : "black"} />
      </div>
    );
  }

  // No data state
  if (records.length === 0) {
    return (
      <div className="grid h-96 place-content-center gap-5">
        <SearchNotFoundAnimation />
        <div>No Missed Calls found</div>
      </div>
    );
  }

  // No missed calls state
  if (missedCalls.length === 0) {
    return (
      <div className="grid h-96 place-content-center gap-5">
        <SearchNotFoundAnimation />
        <div>No Missed Calls Found</div>
      </div>
    );
  }

  // Main content
  return (
    <div className="flex h-[75vh] w-full max-w-full flex-col overflow-y-auto overflow-x-hidden pb-24 lg:my-5 lg:pb-0">
      {missedCalls.map((record) => {
        const call = record.Calls[0];
        const isGroup = record.Chat.chat_type === "group";
        const profileImage = isGroup
          ? record.Chat.group_icon
          : call?.caller?.profile_pic;

        return (
          <div key={record.id || record.createdAt}>
            <div
              className="flex cursor-pointer items-center px-3 py-4 hover:bg-selectedChat"
              onClick={() => { }}
              onContextMenu={() => { }}
            >
              {/* Profile / Group Image */}
              <div className="relative mr-3">
                <LoadingSkeletonImageDynamic
                  radius=""
                  className="min-h-12 min-w-12 rounded-full object-cover 2xl:h-12 2xl:w-12"
                  image_height="100%"
                  image_width=""
                  image_url={profileImage}
                />
              </div>

              {/* Call Info */}
              <div className="flex w-full items-center justify-between">
                <div>
                  <div className="text-base font-medium capitalize text-darkText">
                    {isGroup ? (
                      record.Chat.group_name
                    ) : (
                      <ShowSavedName
                        user_id={call.caller.user_id.toString()}
                        name={call.caller.user_name}
                      />
                    )}
                  </div>
                  <CallInCallHistory callData={record} />
                </div>

                {/* Date and Time */}
                <div className="space-y-1 text-end text-sm text-lightText">
                  <div>{formatDate(record.createdAt.toString())}</div>
                  <div className="text-xs">
                    {formatTime(record.createdAt.toString())}
                  </div>
                </div>
              </div>
            </div>

            <hr className="border-t border-borderColor" />
          </div>
        );
      })}
    </div>
  );
}
