import { OuterChat } from "../../../types/ChatListType";
import { useAppSelector } from "../../../utils/hooks";

interface CallInConversationListProps {
  messageData: OuterChat;
}

export default function CallInConversationList({
  messageData,
}: CallInConversationListProps) {
  const userData = useAppSelector((state) => state.userData);

  // Get the call object safely
  const call = messageData?.Records?.[0]?.Messages?.[0]?.Calls?.[0];
  if (!call) return null;

  const isVideo = call.call_type === "video";
  const isMissed =
    call.call_status === "missed" ||
    (!call.users.includes(userData.user_id.toString()) &&
      call.call_status == "ended");
  const isOutgoing = call.user_id === userData.user_id;

  // --- Icon path ---
  let iconSrc = "";
  if (isMissed) {
    iconSrc = isVideo
      ? "/CallIcons/missed_video_call.png"
      : "/CallIcons/missed_audio_call.png";
  } else {
    iconSrc = isVideo
      ? isOutgoing
        ? "/CallIcons/outgoing_video_call.png"
        : "/CallIcons/incoming_video_call.png"
      : isOutgoing
        ? "/CallIcons/outgoing_audio_call.png"
        : "/CallIcons/incoming_audio_call.png";
  }

  // --- Label ---
  let label = "";
  if (isMissed) {
    label = isVideo ? "Missed Video Call" : "Missed Audio Call";
  } else {
    label = isVideo
      ? isOutgoing
        ? "Outgoing Video Call"
        : "Incoming Video Call"
      : isOutgoing
        ? "Outgoing Audio Call"
        : "Incoming Audio Call";
  }

  return (
    <div className="flex items-center gap-0 text-xs text-darkText">
      <div className="grid h-6 w-6 place-content-center rounded-full">
        <img src={iconSrc} className="h-4 w-4 object-contain" alt="" />
      </div>
      <div>{label}</div>
    </div>
  );
}
