import ReusableProfileCard from "../Profile/ReusableProfileCard";
import { PiUsersThree } from "react-icons/pi";
import { useAppDispatch, useAppSelector } from "../../../utils/hooks";
import { updateCreateGroupData } from "../../../store/Slices/CreateGroupSlice";
import { MdCheck } from "react-icons/md";
import toast from "react-hot-toast";
import { RxCross2 } from "react-icons/rx";

export default function GroupDescriptionInput() {
  const dispatch = useAppDispatch();

  const handleValueChange = (
    newValue: React.ChangeEvent<HTMLTextAreaElement>,
  ) => {
    dispatch(
      updateCreateGroupData({ group_description: newValue.target.value }),
    );
  };

  const CreateGroup = useAppSelector((state) => state.CreateGroup);

  return (
    <div className="mt-2 flex flex-col gap-3 px-4">
      {/* <ReusableProfileCard
        icon={}
        value="Group Name"
        onChange={handleValueChange}
      /> */}
      <div className="flex cursor-pointer items-center justify-between rounded-lg border border-borderColor px-5 py-2 2xl:py-3">
        <div className="flex w-full items-start gap-3">
          {/* <PiUsersThree className="text-2xl" /> */}
            <textarea
              placeholder="Group Description"
              value={CreateGroup.group_description}
              onChange={handleValueChange}
              // onBlur={() => setIsEditing(false)}
              className="w-full border-none bg-transparent outline-none"
            />
        </div>
      </div>
    </div>
  );
}
