import { useAppSelector, useAppDispatch } from "../../../utils/hooks";
import LoadingSkeletonImageDynamic from "../../../components/LoadingSkeletonImageDynamic";
import { MdCancel } from "react-icons/md";
import { addOrRemoveUserId } from "../../../store/Slices/CreateGroupSlice";
import { useContactList } from "../../../store/api/useContactList";
import { ContactType } from "../../../types/ResType";

export default function GroupMembersList() {
  const CreateGroup = useAppSelector((state) => state.CreateGroup);
  const OnlineUserList = useAppSelector((state) => state.OnlineUserList);
  const dispatch = useAppDispatch();
  const { data: contactListUser } = useContactList();
  return (
    <div className="relative mb-28 flex w-full max-w-full flex-col overflow-x-hidden lg:h-[80dvh]">
      {contactListUser?.data
        .filter((contact) => CreateGroup.user_id.includes(contact?.user_id))
        .map((e: ContactType) => {
          return (
            <>
              <div className="flex cursor-pointer items-center px-3 py-4">
                <div className="relative mr-3 h-14 w-14 2xl:h-12 2xl:w-12">
                  <LoadingSkeletonImageDynamic
                    radius=""
                    className="h-10 min-w-10 rounded-full object-cover 2xl:h-12 2xl:w-12"
                    image_height="100%"
                    image_url={e?.profile_pic}
                    image_width=""
                  />
                  {OnlineUserList.onlineUsers.find(
                    (user) => user.user_id == e?.user_id,
                  ) && (
                      <img
                        className="absolute bottom-0 right-0 z-30 h-4 w-4"
                        src="/Home/Online_Green_dot.png"
                        alt=""
                      />
                    )}
                </div>
                <div>
                  <div className="text-base font-medium capitalize text-darkText">
                    {e?.name}
                  </div>
                  <div className="line-clamp-1 flex w-full max-w-[12.5rem] gap-x-1 text-[13px] text-lightText">
                    {e?.user_name}
                  </div>
                </div>
                <div className="ml-auto grid h-full grid-cols-1 place-content-center gap-y-2 text-center">
                  <MdCancel
                    onClick={() => {
                      dispatch(
                        addOrRemoveUserId({
                          user_id: e.user_id,
                        }),
                      );
                    }}
                    className="h-5 w-5 text-themeColor"
                  />
                </div>
              </div>
              <hr className="border-t border-borderColor" />
            </>
          );
        })}
    </div>
  );
}
