import React from "react";
import { useTheme } from "../../../context/ThemeProvider";
import LinkPreview from "../../../components/LinkPreview";
import { useAppSelector } from "../../../utils/hooks";
import chatSidebarTime from "../../../utils/chatSidebarTime";
import TextTranslate from "../../../utils/TextTranslate";
import { useConversationLinks } from "../../../store/api/useConversationLinks";
import { ClipLoader } from "react-spinners";
import SearchNotFoundAnimation from "../../../components/SearchNotFoundAnimation";

export default function Links() {
  // @ts-ignore
  const { theme } = useTheme();

  const userData = useAppSelector((state) => state.userData);

  const { data, isLoading } = useConversationLinks();

  return (
    <div className="space-y-4">
      {isLoading ? (
        <div className="grid h-96 place-content-center gap-5">
          <ClipLoader color={theme == "dark" ? "#fff" : "#000"} size={20} />
        </div>
      ) : data?.data?.Records?.length === 0 ||
        data?.data?.Records?.length === undefined ? (
        <div className="grid h-96 place-content-center text-center gap-5">
          <SearchNotFoundAnimation />
          <div>
            <TextTranslate text="No Links Found" />
          </div>
        </div>
      ) : (
        data.data.Records.map((message, index) => (
          <div
            key={index}
            className={`${
              message.sender_id === userData.user_id ? "ml-auto mr-0" : ""
            } w-[93%]`}
          >
            <LinkPreview
              right={message.sender_id === userData.user_id}
              url={message.message_content}
            />
            <div className="mt-2 text-sm opacity-60">
              {chatSidebarTime(message.createdAt)}
            </div>
          </div>
        ))
      )}
    </div>
  );
}
