import React from "react";
import LoadingSkeletonImageDynamic from "../../../components/LoadingSkeletonImageDynamic";
import { FaAngleRight, FaPlay } from "react-icons/fa6";
import { useAppDispatch } from "../../../utils/hooks";
import {
  setViewImage,
  updateViewState,
} from "../../../store/Slices/ViewManagerSlice";
import { useConversationMedia } from "../../../store/api/useConversationMedia";
import { ClipLoader } from "react-spinners";
import { useTheme } from "../../../context/ThemeProvider";
import { useConversationDocuments } from "../../../store/api/useConversationDocuments";
import { useConversationLinks } from "../../../store/api/useConversationLinks";
import TextTranslate from "../../../utils/TextTranslate";

export default function LinksAndMedia() {
  const dispatch = useAppDispatch();
  const { data, isLoading, refetch } = useConversationMedia();
  const { data: documents } = useConversationDocuments();
  const { data: links } = useConversationLinks();
  const urls = data?.data?.Records?.filter((message) => {
    return (
      (message.message_type === "image" ||
        message.message_type === "gif" ||
        message.message_type === "video") &&
      message.message_content
    );
  });
  const image_urls = urls?.map((message) =>
    message.message_content.replace(/\\/g, "/"),
  );
  // @ts-ignore
  const { theme } = useTheme();
  return (
    <>
      <div className="flex flex-col border border-borderColor px-10 py-3">
        <div
          onClick={() => {
            dispatch(updateViewState({ showMediaDocLinks: true }));
          }}
          className="flex cursor-pointer items-center justify-between text-sm text-darkText"
        >
          <div className="flex gap-2">
            <img
              className="h-5 w-5 object-contain"
              src={`${
                theme == "dark"
                  ? "/DarkIcons"
                  : theme == "light"
                    ? "/LightIcons"
                    : "/DarkIcons"
              }/meida_icon.png`}
              alt=""
            />
            <span> <TextTranslate text="Media, links and docs" /></span>
          </div>
          <div className="flex items-center gap-1">
            <span>{data?.data.pagenation.total_records+documents?.data.pagenation.total_records+links?.data.pagenation.total_records || 0}</span>{" "}
            <span></span>
            <FaAngleRight />
          </div>
        </div>
        <div
          className={` ${data?.data?.pagenation.total_records != 0 && "mt-2"} grid grid-cols-2 gap-2 md:grid-cols-3`}
        >
          {isLoading ? (
            <div className="col-span-3 grid h-24 place-content-center">
              <ClipLoader
                color={theme == "dark" ? "#FCC604" : "#000000"}
                size={20}
              />
            </div>
          ) : (
            data?.data?.Records.slice(0, 3).map((message, index) => {
              return (
                <>
                  {message.message_type == "image" ? (
                    <div
                      className="h-24 w-full cursor-pointer"
                      onClick={() => {
                        dispatch(
                          setViewImage({
                            show_image: true,
                            image_src: image_urls,
                            currentIndex: index,
                          }),
                        );
                      }}
                    >
                      <LoadingSkeletonImageDynamic
                        radius=".75rem"
                        className="h-24 w-full cursor-pointer object-cover"
                        image_height="100%"
                        image_url={
                          message.message_type == "image"
                            ? message.message_content
                            : message.message_thumbnail
                        }
                        image_width=""
                      />
                    </div>
                  ) : message.message_type == "gif" ? (
                    <img
                      onClick={() => {
                        dispatch(
                          setViewImage({
                            show_image: true,
                            image_src: image_urls,
                            currentIndex: index,
                          }),
                        );
                      }}
                      src={message.message_content}
                      className="h-24 w-full cursor-pointer rounded-xl object-cover"
                    />
                  ) : (
                    <div
                      onClick={() => {
                        dispatch(
                          setViewImage({
                            show_image: true,
                            image_src: image_urls,
                            currentIndex: index,
                          }),
                        );
                      }}
                      className="relative cursor-pointer overflow-hidden rounded-xl"
                    >
                      <div className="absolute grid h-full w-full place-content-center">
                        <FaPlay className="h-11 w-11 rounded-full bg-[#0000008F] p-3 text-white" />
                      </div>
                      <img
                        className="h-24 w-full cursor-pointer rounded-xl object-cover"
                        src={
                          message.message_type == "video"
                            ? message.message_thumbnail
                            : message.message_content
                        }
                        alt=""
                      />
                    </div>
                    // <div
                    //   onClick={() => {
                    //     dispatch(
                    //       setViewImage({
                    //         show_image: true,
                    //         image_src: image_urls,
                    //         currentIndex: index,
                    //       }),
                    //     );
                    //   }}
                    //   className="h-24 w-full cursor-pointer object-cover"
                    // >
                    //   <div className="absolute grid h-full w-full place-content-center">
                    //     <FaPlay className="h-11 w-11 rounded-full bg-[#0000008F] p-3 text-white" />
                    //   </div>
                    //   <LoadingSkeletonImageDynamic
                    //     radius=""
                    //     className="h-24 w-full cursor-pointer object-cover"
                    //     image_height="100%"
                    //     image_url={message.thumbnail}
                    //     image_width=""
                    //   />
                    // </div>
                  )}
                </>
              );
            })
          )}
        </div>
      </div>
    </>
  );
}
