import React from "react";
import { setViewImage } from "../../../store/Slices/ViewManagerSlice";
import { useAppDispatch } from "../../../utils/hooks";
import { useConversationMedia } from "../../../store/api/useConversationMedia";
import { FaPlay } from "react-icons/fa6";
import TextTranslate from "../../../utils/TextTranslate";
import SearchNotFoundAnimation from "../../../components/SearchNotFoundAnimation";

export default function Media() {
  const dispatch = useAppDispatch();
  const { data, isLoading, refetch } = useConversationMedia();

  const urls = data?.data?.Records?.filter((message) => {
    return (
      (message.message_type === "image" || message.message_type === "gif" || message.message_type === "video") &&
      message.message_content
    );
  });
  console.log(data?.data?.Records, "data?.data?.Records");

  const image_urls = urls?.map((message) =>
    message.message_content.replace(/\\/g, "/"),
  );
  console.log(image_urls, "image_urls");
  return (
    <div className="space-y-4">
      {data?.data?.Records.length == 0 ||
        data?.data?.Records?.length == undefined ? (
        <div className="grid h-96 w-full place-content-center text-center gap-5">
          <SearchNotFoundAnimation />
          <div>
            <TextTranslate text="No Media Found!" />
          </div>
        </div>
      ) : (
        <div className="grid grid-cols-2 gap-2 md:grid-cols-3">
          {data?.data?.Records.map((message, index) => {
            return (
              <>
                {message.message_type == "image" ? (
                  <img
                    onClick={() => {
                      dispatch(
                        setViewImage({
                          show_image: true,
                          image_src: image_urls,
                          currentIndex: index,
                        }),
                      );
                    }}
                    className="h-24 w-full cursor-pointer object-cover"
                    src={
                      message.message_type == "image"
                        ? message.message_content
                        : message.message_thumbnail
                    }
                    alt=""
                  />
                ) : (
                  <div
                    onClick={() => {
                      dispatch(
                        setViewImage({
                          show_image: true,
                          image_src: image_urls,
                          currentIndex: index,
                        }),
                      );
                    }}
                    className="relative cursor-pointer"
                  >
                    <div className="absolute grid h-full w-full place-content-center">
                      <FaPlay className="h-11 w-11 rounded-full bg-[#0000008F] p-3 text-white" />
                    </div>
                    <img
                      className="h-24 w-full cursor-pointer object-cover"
                      src={
                        message.message_type == "video"
                          ? message.message_thumbnail
                          : message.message_content
                      }
                      alt=""
                    />
                  </div>
                )}
              </>
            );
          })}
        </div>
      )}
    </div>
  );
}
