import React, { useState } from "react";
import { GoChevronLeft } from "react-icons/go";
import { updateViewState } from "../../../store/Slices/ViewManagerSlice";
import { useAppDispatch, useAppSelector } from "../../../utils/hooks";
import Media from "./Media";
import Documents from "./Documents";
import Links from "./Links";
import TextTranslate from "../../../utils/TextTranslate";

export default function MediaLinksDocsTabs() {
  const [selectedTab, setSelectedTab] = useState(0);
  const dispatch = useAppDispatch();
  const currentConversationData = useAppSelector(
    (state) => state.CurrentConversation,
  );
  return (
    <div>
      <div className="flex items-center gap-3 bg-otherProfileSidebar px-3 py-10">
        <GoChevronLeft
          className="cursor-pointer text-xl"
          onClick={() => {
            dispatch(updateViewState({ showMediaDocLinks: false }));
          }}
        />
        <span className="">
          <TextTranslate
            text={
              currentConversationData.chat_type == "group"
                ? "Group Info"
                : "Contact Info"
            }
          />
        </span>
      </div>
      <div className="mt-4 grid grid-cols-3 w-full bg-otherProfileSidebar text-sm lg:max-w-96 ">
        <div
          onClick={() => {
            setSelectedTab(0);
          }}
          className={`p-2 ${
            selectedTab == 0
              ? "border-b border-themeColor text-themeColor"
              : "opacity-50"
          } cursor-pointer text-center font-medium `}
        >
          <TextTranslate text="Media" />
        </div>

        <div
          onClick={() => {
            setSelectedTab(1);
          }}
          className={`p-2 ${
            selectedTab == 1
              ? "border-b border-themeColor text-themeColor"
              : "opacity-50"
          } cursor-pointer text-center font-medium `}
        >
          <TextTranslate text="Docs" />
        </div>
        <div
          onClick={() => {
            setSelectedTab(2);
          }}
          className={`p-2 ${
            selectedTab == 2
              ? "border-b border-themeColor text-themeColor"
              : "opacity-50"
          } cursor-pointer text-center font-medium `}
        >
          <TextTranslate text="Links" />
        </div>
      </div>
      <div className="px-7 py-5">
        {selectedTab == 0 && <Media />}
        {selectedTab == 1 && <Documents />}
        {selectedTab == 2 && <Links />}
      </div>
    </div>
  );
}
