import React from "react";
import { useTheme } from "../../../context/ThemeProvider";
import { Message, MessageList } from "../../../types/MessageListType";
import useApiPost from "../../../hooks/PostData";
import { useAppDispatch, useAppSelector } from "../../../utils/hooks";
import { appendMessageWithDateCheck } from "../../../store/Slices/MessageListSlice";
import { updateSendMessageData } from "../../../store/Slices/SendMessageSlice";
import { socketInstance } from "../../../socket/socket";
import { useFile } from "../../../context/FileProvider";
import Button from "../../../components/Button";
import { useConversationInfo } from "../../../store/api/useConversationInfo";
import toast from "react-hot-toast";

export default function EmptyMessageList() {
  // @ts-ignore
  const { theme } = useTheme();
  const { loading: sendMessageLoading, postData } = useApiPost();
  const currentConversationData = useAppSelector(
    (state) => state.CurrentConversation,
  );
  const CreateGroup = useAppSelector((state) => state.CreateGroup);
  const userData = useAppSelector((state) => state.userData);
  const dispatch = useAppDispatch();
  const { selectedFile, setSelectedFile } = useFile();
  const { refetch } = useConversationInfo();
  const ChatListArray = useAppSelector((state) => state.chatList);

  async function sendMessageApiCall() {
    const messageFormData = new FormData();

    // Ensure chat_id is present, otherwise return early
    if (
      !currentConversationData.chat_id &&
      currentConversationData.user_id == 0
    ) {
      return;
    }

    if (
      currentConversationData.chat_id != -1 &&
      currentConversationData.chat_id != 0
    ) {
      // Append chat_id
      messageFormData.append(
        "chat_id",
        currentConversationData.chat_id.toString(),
      );
      messageFormData.append(
        "user_id",
        String(currentConversationData.user_id),
      );
    } else {
      messageFormData.append(
        "user_id",
        String(currentConversationData.user_id),
      );
    }
    // Append message_type
    messageFormData.append("message_type", "text");

    messageFormData.append(
      "other_user_id",
      String(currentConversationData.user_id),
    );
    messageFormData.append("message_content", "Hi");

    // Make the API call with the constructed FormData
    const { data: sendMessageRes }: { data: Message } = await postData(
      "chat/send-message",
      messageFormData,
      "multipart/form-data",
    );

    // Handle the response (if needed)
    if (sendMessageRes) {
      // Remove Value from input box
      dispatch(
        updateSendMessageData({
          message: "",
          message_type: "",
        }),
      );
      // Remove selected files
      setSelectedFile(null);
    } else {
      toast.error("Something went wrong");
    }
  }

  async function joinInGroup() {
    await postData("add-member-to-group", {
      multiple_user_id: String(userData.user_id),
      chat_id: currentConversationData.chat_id,
    });
    socketInstance().emit("ChatList", {});
    toast.success(`You joined this group`);
    refetch();
  }

  return (
    <div className="flex h-[83dvh] flex-col items-center justify-center gap-y-2 overflow-y-auto px-14 py-6">
      <div
        onClick={() => {
          // if (
          //   currentConversationData.public_group &&
          //   !ChatListArray.some(
          //     (chatUser) =>
          //       chatUser.chat_id === currentConversationData.chat_id,
          //   )
          // ) {
          //   joinInGroup();
          // } else {
          // sendMessageApiCall();
          // }
        }}
        className=" rounded-lg transition-all duration-500 "
      >
        {/* <img
          className="h-52 object-contain lg:h-64"
          src={` ${theme == "dark" ? "/DarkIcons/start_conversations_dark.png" : "/LightIcons/start_conversation_light.png"} `}
          alt=""
        /> */}
        {theme == "dark" ? <HiSvgDark /> : <HiSvgLIght />}
        <div className="text-xl">Start Conversation</div>
      </div>

      {/* {currentConversationData.public_group &&
      !ChatListArray.some(
        (chatUser) => chatUser.chat_id === currentConversationData.chat_id,
      ) ? (
        <Button
          onClickFunc={joinInGroup}
          className={"!h-10 !w-fit"}
          text={"Join Now"}
        />
      ) : (
        <div className="text-xl">Start Conversation</div>
      )} */}
    </div>
  );
}




function HiSvgLIght() {
  return (
    <>
      <svg width="189" height="189" viewBox="0 0 189 189" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M189 144.547H0V144.641H189V144.547Z" fill="#EBEBEB" />
        <path d="M170.067 150.63H157.547V150.724H170.067V150.63Z" fill="#EBEBEB" />
        <path d="M125.2 151.656H121.914V151.751H125.2V151.656Z" fill="#EBEBEB" />
        <path d="M157.161 147.12H149.906V147.215H157.161V147.12Z" fill="#EBEBEB" />
        <path d="M36.1551 147.755H19.8281V147.849H36.1551V147.755Z" fill="#EBEBEB" />
        <path d="M41.9173 147.755H39.5234V147.849H41.9173V147.755Z" fill="#EBEBEB" />
        <path d="M85.1048 149.352H49.6953V149.446H85.1048V149.352Z" fill="#EBEBEB" />
        <path d="M89.5944 127.688H16.6029C15.4134 127.688 14.4453 126.72 14.4453 125.53V22.9291C14.4453 21.7395 15.4134 20.7715 16.6029 20.7715H89.5944C90.7835 20.7715 91.7516 21.7395 91.7516 22.9291V125.53C91.7516 126.72 90.7835 127.688 89.5944 127.688ZM16.6029 20.8664C15.4652 20.8664 14.5398 21.7917 14.5398 22.9295V125.531C14.5398 126.669 15.4652 127.594 16.6029 127.594H89.5944C90.7318 127.594 91.6571 126.669 91.6571 125.531V22.9291C91.6571 21.7917 90.7318 20.866 89.5944 20.866L16.6029 20.8664Z" fill="#EBEBEB" />
        <path d="M171.351 127.688H98.3604C97.1708 127.688 96.2031 126.72 96.2031 125.53V22.9291C96.2031 21.7395 97.1712 20.7715 98.3604 20.7715H171.351C172.541 20.7715 173.509 21.7395 173.509 22.9291V125.53C173.509 126.72 172.541 127.688 171.351 127.688ZM98.3604 20.8664C97.223 20.8664 96.2976 21.7917 96.2976 22.9295V125.531C96.2976 126.669 97.223 127.594 98.3604 127.594H171.351C172.489 127.594 173.415 126.669 173.415 125.531V22.9291C173.415 21.7917 172.489 20.866 171.351 20.866L98.3604 20.8664Z" fill="#EBEBEB" />
        <path d="M94.4932 161.617C134.97 161.617 167.783 159.701 167.783 157.337C167.783 154.973 134.97 153.057 94.4932 153.057C54.0162 153.057 21.2031 154.973 21.2031 157.337C21.2031 159.701 54.0162 161.617 94.4932 161.617Z" fill="#F5F5F5" />
        <path d="M139.977 57.0408C140.911 54.0001 131.362 53.3307 129.06 58.7607C125.835 66.3694 130.536 70.6503 130.536 70.6503C133.277 69.1776 138.636 68.958 141.566 69.9294L139.977 57.0408Z" fill="#263238" />
        <path d="M140.722 154.218L137.776 154.333L137.758 151.147L140.704 151.032L140.722 154.218Z" fill="#B55B52" />
        <path d="M137.648 153.722H140.982C141.104 153.722 141.213 153.806 141.246 153.924L141.971 156.562C142.046 156.836 141.845 157.095 141.564 157.09C140.399 157.07 139.83 157.002 138.364 157.002C137.462 157.002 135.131 157.095 133.885 157.095C132.667 157.095 132.412 155.864 132.916 155.752C135.176 155.252 136.479 154.562 137.176 153.904C137.302 153.786 137.471 153.722 137.648 153.722Z" fill="var(--theme-color)" />
        <path opacity="0.2" d="M137.758 151.148L137.766 152.789L140.715 152.805L140.706 151.032L137.758 151.148Z" fill="black" />
        <path d="M131.023 92.1658C130.542 95.7961 132.18 113.01 133.559 120.522C135.391 130.5 137.128 152.126 137.128 152.126L141.101 151.888C141.101 151.888 141.579 128.177 140.363 120.131C140.284 109.58 140.474 91.1055 140.474 91.1055L131.023 92.1658Z" fill="#263238" />
        <path opacity="0.2" d="M140.385 102.602C140.385 99.9255 138.403 97.8125 137.908 102.922C137.592 106.177 138.859 111.638 140.345 115.417C140.34 111.298 140.361 106.689 140.385 102.602Z" fill="black" />
        <path d="M158.257 154.546L155.552 154.619L154.281 150.934L156.987 150.86L158.257 154.546Z" fill="#B55B52" />
        <path d="M158.18 153.721H154.846C154.725 153.721 154.646 153.805 154.657 153.923L154.903 156.561C154.929 156.835 155.225 157.094 155.504 157.089C156.662 157.069 157.205 157.001 158.672 157.001C159.574 157.001 160.764 157.094 162.009 157.094C163.227 157.094 163.029 155.863 162.484 155.751C160.04 155.251 159.659 154.561 158.719 153.903C158.55 153.785 158.358 153.721 158.18 153.721Z" fill="var(--theme-color)" />
        <path opacity="0.2" d="M154.281 150.935L154.936 152.834L157.694 152.913L156.988 150.861L154.281 150.935Z" fill="black" />
        <path d="M135.547 91.6561C135.547 91.6561 141.675 114.09 144.753 120.709C146.75 130.934 153.907 152.362 153.907 152.362L158.057 152.073C158.057 152.073 153.512 130.393 150.73 120.331C149.227 110.975 148.231 95.3828 143.917 90.7168L135.547 91.6561Z" fill="#263238" />
        <path d="M129.614 75.4785C129.534 77.3689 129.371 79.2037 129.148 81.0581C128.933 82.9081 128.654 84.7538 128.294 86.5936L128.153 87.283L128.078 87.6467C128.031 87.8414 127.985 88.0368 127.864 88.2934C127.746 88.5388 127.567 88.8449 127.208 89.1186C126.853 89.3976 126.345 89.5246 125.991 89.5038C125.63 89.4906 125.378 89.4051 125.166 89.3224C124.954 89.2366 124.8 89.1443 124.648 89.0517C124.083 88.6809 123.72 88.3108 123.361 87.9366C123.015 87.5601 122.702 87.181 122.405 86.7988C121.24 85.2551 120.263 83.6818 119.383 82.0096C119.174 81.6119 119.326 81.1201 119.724 80.9111C120.068 80.7304 120.482 80.82 120.723 81.1046L120.737 81.1209C121.902 82.4957 123.078 83.9052 124.308 85.1458C124.612 85.4566 124.923 85.7537 125.231 86.0194C125.532 86.2813 125.857 86.5297 126.079 86.6352C126.127 86.6559 126.174 86.6749 126.178 86.6684C126.18 86.665 126.153 86.6408 126.022 86.6321C125.898 86.6163 125.623 86.6771 125.45 86.814C125.274 86.947 125.222 87.0532 125.198 87.0914C125.176 87.1398 125.181 87.1095 125.183 87.0808L125.227 86.7663L125.321 86.0992C125.561 84.3165 125.751 82.5191 125.925 80.7183C126.083 78.9213 126.229 77.0967 126.349 75.3209L126.351 75.2986C126.412 74.3978 127.191 73.717 128.092 73.7782C128.978 73.838 129.651 74.5962 129.614 75.4785Z" fill="#B55B52" />
        <path d="M128.229 72.9683C125.424 74.3382 125.861 77.9753 125.861 77.9753L130.348 81.1361C130.348 81.1361 131.987 77.186 131.65 75.2908C131.298 73.318 130.307 71.9534 128.229 72.9683Z" fill="var(--theme-color)" />
        <path opacity="0.2" d="M127.737 76.0007C128.398 74.9657 129.526 75.2167 130.842 76.0407C131.122 76.2717 131.373 76.5911 131.589 76.9744C131.273 78.8916 130.341 81.1354 130.341 81.1354L127.178 78.9079C127.027 78.1201 127.266 76.7366 127.737 76.0007Z" fill="black" />
        <path d="M120.93 81.612L120.262 79.0518L117.992 81.093C117.992 81.093 118.812 82.4617 120.129 82.6477L120.93 81.612Z" fill="#B55B52" />
        <path d="M118.525 78.0099L118.063 78.4673C117.34 79.1825 117.309 80.3403 117.993 81.0932L120.263 79.052L119.628 78.1176C119.375 77.7449 118.846 77.6931 118.525 78.0099Z" fill="#B55B52" />
        <path d="M119.679 78.1841C119.092 77.4436 118.271 76.0563 118.127 75.7679C117.983 75.4795 117.517 75.8791 117.739 76.3005C117.961 76.7224 118.393 78.087 118.848 78.5863C119.303 79.0856 119.679 78.1841 119.679 78.1841Z" fill="#B55B52" />
        <path d="M127.192 75.0286C127.986 82.3315 130.369 87.4239 131.021 92.1648L143.926 90.7167C143.195 85.9747 142.823 82.8698 143.731 74.0802C143.898 72.4646 142.645 71.0539 141.021 71.029C140.236 71.0169 139.364 71.0271 138.49 71.0826C136.307 71.2217 134.52 71.3521 132.63 71.7403C131.27 72.0197 129.822 72.4162 128.787 72.7186C127.776 73.0142 127.078 73.9808 127.192 75.0286Z" fill="var(--theme-color)" />
        <path d="M132.632 71.7407C132.632 71.7407 130.562 73.9819 133.65 77.0444C135.558 73.1828 138.492 71.083 138.492 71.083L132.632 71.7407Z" fill="white" />
        <path d="M137.173 64.5488C137.015 66.4759 137.033 69.972 138.494 71.0822C138.494 71.0822 135.267 72.838 133.528 75.9228C131.253 73.6371 132.634 71.7399 132.634 71.7399C134.68 71.002 134.451 69.4481 133.92 68.0242L137.173 64.5488Z" fill="#B55B52" />
        <path opacity="0.2" d="M136.82 64.9287C136.856 65.4885 136.936 66.7699 136.4 68.2528C136.137 68.9843 135.24 69.405 134.285 69.5823C134.266 69.0769 134.114 68.5428 133.922 68.0249L136.82 64.9287Z" fill="black" />
        <path d="M139.91 61.8539C139.348 64.9769 139.176 66.3109 137.397 67.739C134.722 69.8868 131.009 68.5124 130.628 65.2839C130.284 62.3782 131.262 57.759 134.489 56.8688C137.668 55.9922 140.474 58.7308 139.91 61.8539Z" fill="#B55B52" />
        <path d="M137.496 59.3512C136.74 61.0209 137.402 63.8559 139.797 63.6824C137.86 65.8956 138.322 70.7445 138.322 70.7445C139.612 70.8508 140.753 70.5359 141.813 69.9957C141.813 69.9957 141.058 65.411 141.856 62.193C142.505 59.5761 142.409 54.5 136.74 55.6026C136.079 55.7311 131.77 56.8629 131.336 59.1263C131.299 59.3187 135.934 60.6606 137.496 59.3512Z" fill="#263238" />
        <path d="M140.603 63.6245C140.463 64.2671 140.038 64.7849 139.579 65.0692C138.887 65.4967 138.316 64.9327 138.32 64.162C138.324 63.4684 138.688 62.41 139.473 62.2943C140.246 62.1805 140.764 62.8897 140.603 63.6245Z" fill="#B55B52" />
        <path opacity="0.2" d="M141.693 76.1847C141.552 77.2938 142.105 78.6814 143.279 79.5085C143.347 78.2021 143.463 76.7362 143.627 75.0503C142.97 74.3423 141.85 74.9581 141.693 76.1847Z" fill="black" />
        <path d="M144.034 89.9378L144.746 91.0275C144.801 91.1122 144.705 91.2154 144.556 91.232L131.022 92.7505C130.905 92.7637 130.803 92.7172 130.787 92.645L130.541 91.5031C130.524 91.4241 130.617 91.3447 130.744 91.3307L143.813 89.8644C143.909 89.8539 143.999 89.8833 144.034 89.9378Z" fill="#263238" />
        <path d="M142.44 91.5958L142.79 91.5565C142.859 91.5485 142.908 91.5066 142.898 91.4635L142.566 89.981C142.556 89.9375 142.491 89.9084 142.421 89.9163L142.071 89.9557C142.002 89.9636 141.953 90.0056 141.962 90.0486L142.295 91.5312C142.305 91.5746 142.37 91.6037 142.44 91.5958Z" fill="var(--theme-color)" />
        <path d="M132.017 92.7657L132.367 92.7264C132.437 92.7185 132.486 92.6765 132.476 92.6334L132.144 91.1509C132.134 91.1074 132.069 91.0783 131.999 91.0863L131.649 91.1256C131.58 91.1335 131.53 91.1755 131.54 91.2186L131.873 92.7011C131.883 92.7446 131.948 92.7737 132.017 92.7657Z" fill="var(--theme-color)" />
        <path d="M137.236 92.1817L137.586 92.1424C137.655 92.1345 137.704 92.0925 137.695 92.0494L137.362 90.5669C137.353 90.5234 137.288 90.4943 137.218 90.5023L136.868 90.5416C136.798 90.5495 136.749 90.5915 136.759 90.6346L137.092 92.1171C137.101 92.1606 137.166 92.1897 137.236 92.1817Z" fill="var(--theme-color)" />
        <path d="M134.58 62.1726C134.55 62.4289 134.39 62.6205 134.222 62.6009C134.055 62.5812 133.943 62.3574 133.974 62.1015C134.004 61.8452 134.164 61.6536 134.331 61.6733C134.499 61.6925 134.61 61.9163 134.58 62.1726Z" fill="#263238" />
        <path d="M131.689 61.8318C131.659 62.0881 131.499 62.2797 131.332 62.2601C131.164 62.2404 131.053 62.0166 131.083 61.7607C131.113 61.5044 131.273 61.3128 131.441 61.3324C131.608 61.3521 131.719 61.5759 131.689 61.8318Z" fill="#263238" />
        <path d="M131.508 61.3559L130.914 61.1064C130.914 61.1064 131.173 61.6239 131.508 61.3559Z" fill="#263238" />
        <path d="M132.394 62.3623C132.394 62.3623 131.83 63.4139 131.289 63.8898C131.59 64.2451 132.182 64.1684 132.182 64.1684L132.394 62.3623Z" fill="#A02724" />
        <path d="M132.903 65.0619C132.878 65.0464 132.863 65.017 132.868 64.986C132.874 64.9448 132.913 64.916 132.954 64.9225C134.07 65.0926 134.715 64.3906 134.721 64.3838C134.749 64.3528 134.796 64.3494 134.828 64.3778C134.859 64.4057 134.862 64.4534 134.834 64.4847C134.806 64.5161 134.131 65.2551 132.931 65.0725C132.921 65.0706 132.911 65.0669 132.903 65.0619Z" fill="#263238" />
        <path d="M135.948 60.8253C135.926 60.8125 135.907 60.7943 135.893 60.7705C135.551 60.188 134.994 60.1555 134.988 60.1551C134.904 60.1514 134.84 60.0799 134.844 59.9967C134.848 59.9132 134.919 59.8486 135.002 59.8527C135.032 59.8542 135.73 59.8951 136.154 60.6174C136.196 60.6896 136.172 60.7822 136.1 60.8249C136.051 60.8529 135.993 60.8514 135.948 60.8253Z" fill="#263238" />
        <path d="M130.913 60.3253C130.904 60.3207 130.897 60.3151 130.889 60.309C130.825 60.255 130.818 60.1593 130.872 60.0955C131.415 59.457 132.109 59.5375 132.139 59.5413C132.221 59.5523 132.28 59.6279 132.27 59.7106C132.259 59.7934 132.184 59.852 132.101 59.8418C132.075 59.8388 131.535 59.7836 131.103 60.2916C131.055 60.348 130.975 60.3604 130.913 60.3253Z" fill="#263238" />
        <path d="M143.582 73.0254C144.694 74.1503 145.748 75.2934 146.777 76.4924C147.289 77.0915 147.806 77.691 148.297 78.3257C148.79 78.9675 149.279 79.5924 149.748 80.3752C149.867 80.5778 149.985 80.7831 150.109 81.0639C150.171 81.2083 150.238 81.3675 150.299 81.6302C150.314 81.7046 150.327 81.7587 150.337 81.8676L150.348 82.0135C150.35 82.063 150.348 82.1461 150.343 82.2108L150.333 82.314L150.326 82.3609L150.324 82.3703L150.315 82.4089L150.298 82.4856C150.2 82.8942 150.129 83.3028 149.999 83.7062C149.779 84.5162 149.473 85.3123 149.113 86.083C148.734 86.8496 148.284 87.5897 147.73 88.2607C147.46 88.6001 147.147 88.912 146.819 89.2064C146.652 89.3523 146.479 89.4933 146.296 89.6268C146.203 89.6941 146.107 89.7564 146.007 89.8188C145.899 89.8842 145.819 89.9318 145.658 90.0157L144.841 88.6175C144.845 88.5994 144.921 88.5306 144.966 88.4784L145.124 88.2996C145.23 88.1756 145.332 88.0441 145.43 87.908C145.623 87.6317 145.801 87.3418 145.964 87.0394C146.287 86.4349 146.548 85.7908 146.763 85.1286C146.856 84.7884 146.965 84.4595 147.034 84.111C147.124 83.7719 147.185 83.4223 147.245 83.0726C147.313 82.7268 147.34 82.3654 147.395 82.0154L147.404 81.9492L147.409 81.9163L147.41 81.908L147.405 81.9367L147.397 82.0036C147.392 82.0441 147.394 82.1031 147.394 82.1284C147.394 82.153 147.395 82.1775 147.398 82.2021L147.411 82.297C147.426 82.3718 147.421 82.3499 147.401 82.3189C147.362 82.249 147.281 82.1216 147.194 81.9968C146.824 81.4778 146.343 80.8916 145.857 80.3355C145.364 79.7757 144.866 79.2049 144.351 78.6462L141.234 75.2998L143.582 73.0254Z" fill="#B55B52" />
        <path d="M146.503 89.4941L144.232 91.6015L142.766 89.1887C142.766 89.1887 144.176 88.1726 145.449 88.5563L146.503 89.4941Z" fill="#B55B52" />
        <path d="M142.511 92.0454L141.77 91.2546C141.474 90.9382 141.484 90.4434 141.794 90.1399L142.764 89.1885L144.23 91.6012L143.598 92.1176C143.273 92.383 142.798 92.3516 142.511 92.0454Z" fill="#B55B52" />
        <path d="M138.467 72.9227C138.294 74.2714 141.891 78.2056 141.891 78.2056L145.252 73.9936C145.252 73.9936 143.683 71.7944 142.487 71.2943C140.561 70.4887 138.665 71.3835 138.467 72.9227Z" fill="var(--theme-color)" />
        <path d="M134.407 61.6958L133.812 61.4463C133.812 61.4463 134.072 61.9638 134.407 61.6958Z" fill="#263238" />
        <path d="M143.689 38.4317C147.708 38.4317 150.977 41.7007 150.977 45.7188V101.242C150.977 105.26 147.708 108.529 143.689 108.529H125.204C122.073 108.529 119.534 111.068 119.534 114.199V119.577L108.228 109.893C107.201 109.013 105.892 108.53 104.54 108.53H45.3165C41.2983 108.53 38.0294 105.261 38.0294 101.242V45.7184C38.0294 41.7003 41.2983 38.4313 45.3165 38.4313L143.689 38.4317ZM143.689 32.7617H45.3165C38.19 32.7617 32.3594 38.5924 32.3594 45.7188V101.242C32.3594 108.369 38.19 114.199 45.3165 114.199H104.54L125.204 131.898V114.199H143.689C150.816 114.199 156.647 108.369 156.647 101.242V45.7184C156.647 38.5924 150.816 32.7617 143.689 32.7617Z" fill="var(--theme-color)" />
        <path d="M58.4508 155.01C58.7955 155.01 59.127 154.962 59.2329 154.807C59.2699 154.753 59.2971 154.661 59.217 154.529C59.1724 154.456 59.1025 154.405 59.0099 154.38C58.5581 154.259 57.6392 154.794 57.6003 154.817C57.578 154.83 57.5663 154.856 57.5716 154.882C57.5769 154.908 57.5977 154.929 57.6241 154.934C57.7965 154.969 58.1295 155.01 58.4508 155.01ZM58.8575 154.489C58.9025 154.489 58.9441 154.494 58.9811 154.504C59.0405 154.519 59.0824 154.548 59.1093 154.593C59.1573 154.672 59.1422 154.711 59.127 154.733C59.0087 154.907 58.3295 154.911 57.8275 154.84C58.0713 154.713 58.5434 154.489 58.8575 154.489Z" fill="var(--theme-color)" />
        <path d="M57.6365 154.936C57.6456 154.936 57.6543 154.935 57.6622 154.931C57.9813 154.785 58.6016 154.204 58.5411 153.9C58.5267 153.829 58.4731 153.74 58.2973 153.722C58.1661 153.709 58.0497 153.746 57.9484 153.832C57.6173 154.112 57.5723 154.836 57.5704 154.867C57.5693 154.889 57.5798 154.912 57.5987 154.925C57.6105 154.932 57.6237 154.936 57.6365 154.936ZM58.2512 153.847C58.2636 153.847 58.2765 153.848 58.2893 153.849C58.4043 153.861 58.4133 153.906 58.4164 153.92C58.4526 154.103 58.0334 154.56 57.7099 154.758C57.7363 154.547 57.8157 154.114 58.0334 153.93C58.0988 153.874 58.1703 153.847 58.2512 153.847Z" fill="var(--theme-color)" />
        <path d="M54.6875 154.872H57.3747L57.4072 148.649H54.7204L54.6875 154.872Z" fill="#CE7A63" />
        <path d="M57.3381 154.562H54.4036C54.2936 154.562 54.2014 154.638 54.1818 154.745L53.741 157.134C53.6953 157.381 53.8922 157.616 54.1455 157.612C55.2035 157.593 56.7306 157.531 58.0612 157.531C59.617 157.531 59.8083 157.616 61.6325 157.616C62.7355 157.616 62.9997 156.501 62.534 156.4C60.4146 155.94 59.8518 155.891 57.9927 154.771C57.7913 154.649 57.5698 154.562 57.3381 154.562Z" fill="#263238" />
        <path opacity="0.2" d="M57.4077 148.652L57.3915 151.86H54.7031L54.7194 148.652H57.4077Z" fill="black" />
        <path d="M36.8836 154.082C36.8643 153.737 36.7985 153.404 36.6371 153.291C36.5808 153.252 36.4867 153.221 36.3593 153.295C36.2878 153.336 36.2413 153.404 36.2217 153.496C36.1249 153.942 36.7123 154.884 36.7373 154.924C36.7516 154.947 36.7785 154.96 36.8046 154.956C36.8307 154.952 36.8503 154.932 36.8541 154.906C36.8787 154.735 36.9013 154.404 36.8836 154.082ZM36.3389 153.653C36.3362 153.608 36.3385 153.567 36.3464 153.53C36.3593 153.471 36.3861 153.431 36.4285 153.406C36.5048 153.361 36.5453 153.378 36.5687 153.395C36.7494 153.521 36.791 154.2 36.7482 154.699C36.6065 154.449 36.3563 153.967 36.3389 153.653Z" fill="var(--theme-color)" />
        <path d="M36.8638 154.894C36.8634 154.885 36.8607 154.876 36.8566 154.868C36.6929 154.543 36.076 153.897 35.7747 153.944C35.704 153.955 35.6179 154.005 35.6099 154.18C35.6039 154.31 35.6474 154.428 35.7384 154.534C36.0382 154.877 36.7662 154.954 36.7972 154.957C36.8199 154.96 36.8415 154.95 36.8535 154.932C36.8611 154.92 36.8645 154.907 36.8638 154.894ZM35.7377 154.232C35.7369 154.219 35.7369 154.206 35.7377 154.193C35.743 154.079 35.7876 154.072 35.8023 154.07C35.983 154.041 36.4642 154.481 36.6816 154.813C36.4684 154.777 36.0295 154.679 35.8329 154.453C35.7732 154.385 35.7422 154.312 35.7377 154.232Z" fill="var(--theme-color)" />
        <path d="M36.8203 154.913L39.4538 155.098L40.5395 148.825L37.9059 148.64L36.8203 154.913Z" fill="#CE7A63" />
        <path d="M36.7921 154.309L39.6993 154.051C39.8081 154.041 39.9136 154.109 39.9533 154.213L40.8367 156.546C40.9281 156.787 40.7769 157.038 40.5252 157.056C39.474 157.131 37.9491 157.204 36.631 157.322C35.0899 157.459 36.0931 157.455 34.2859 157.616C33.1931 157.713 32.7229 156.629 33.1651 156.488C35.1788 155.845 35.5231 155.4 36.182 154.575C36.3226 154.399 36.5622 154.33 36.7921 154.309Z" fill="#263238" />
        <path opacity="0.2" d="M40.5375 148.826L39.9784 152.059L37.3438 151.873L37.9024 148.64L40.5375 148.826Z" fill="black" />
        <path d="M58.3681 86.5209C58.3681 86.5209 53.4628 107.161 51.5909 114.823C49.5414 123.213 41.49 151.048 41.49 151.048L36.6875 150.007C36.6875 150.007 41.9028 126.091 43.9553 114.39C45.5319 105.403 49.0938 86.5205 49.0938 86.5205H58.3681V86.5209Z" fill="#263238" />
        <path d="M42.2296 149.583C42.2515 149.585 41.878 151.433 41.878 151.433L36.1411 150.821L36.0625 149.128L42.2296 149.583Z" fill="var(--theme-color)" />
        <path opacity="0.3" d="M55.535 96.0862C52.1428 96.5371 51.5176 108.457 51.4375 115.451C51.4889 115.23 51.5441 115.02 51.5913 114.821C52.6127 110.638 54.5382 102.577 56.0771 96.1243C55.9134 96.071 55.7301 96.0593 55.535 96.0862Z" fill="black" />
        <path d="M63.4681 86.5205C63.4681 86.5205 62.1538 106.623 61.5698 114.806C60.9623 123.318 58.5291 151.238 58.5291 151.238H53.9769C53.9769 151.238 53.4938 123.827 53.3611 115.456C53.2167 106.331 54.02 86.5205 54.02 86.5205H63.4681Z" fill="#263238" />
        <path d="M59.1709 149.424C59.192 149.424 58.9853 151.314 58.9853 151.314H53.4479L53.2344 149.627L59.1709 149.424Z" fill="var(--theme-color)" />
        <path d="M50.7571 67.1774C50.0231 68.6611 49.2818 70.2222 48.5905 71.7565C47.8998 73.2961 47.2281 74.8474 46.6868 76.3938L46.4823 76.9721L46.3009 77.5475L46.2174 77.809C46.2177 77.7826 46.2242 77.7236 46.2128 77.6238C46.2136 77.4152 46.0136 77.0496 45.8692 76.9672C45.7248 76.8671 45.7207 76.9083 45.7778 76.9385C45.8397 76.974 45.9622 77.0156 46.1036 77.0489C46.3912 77.1135 46.7568 77.1649 47.1351 77.1884C48.6736 77.2753 50.4192 77.1577 52.0919 77.0428L52.1376 77.0398C52.6978 77.0012 53.1828 77.4242 53.2213 77.9844C53.2527 78.4403 52.9771 78.8466 52.5723 79.0028C50.8577 79.6624 49.1624 80.17 47.2217 80.3862C46.7311 80.4312 46.2242 80.4668 45.6492 80.4169C45.3601 80.3912 45.0539 80.3503 44.7016 80.2524C44.3489 80.1443 43.9373 80.0052 43.4701 79.6106C43.2417 79.4136 43.0119 79.1456 42.8483 78.816C42.6842 78.4887 42.5988 78.1315 42.5765 77.8105C42.5561 77.493 42.5889 77.2171 42.6377 76.9786L42.7216 76.6096L42.8815 75.9258L43.0611 75.2575C43.554 73.4813 44.1826 71.8 44.8596 70.1424C45.5547 68.4868 46.2918 66.8966 47.1499 65.287C47.6787 64.2944 48.9125 63.9187 49.9048 64.4479C50.8781 64.9669 51.2584 66.1629 50.7738 67.1449L50.7571 67.1774Z" fill="#CF7A64" />
        <path d="M52.1919 77.1532L53.8634 76.4951L53.7807 79.5989C53.7807 79.5989 52.7449 79.5558 51.9031 78.9612C51.6192 78.7605 51.5017 78.3953 51.5928 78.06L51.685 77.7195C51.7546 77.4613 51.9428 77.2511 52.1919 77.1532Z" fill="#CE7A63" />
        <path d="M56.6147 76.1436L56.013 78.8353L53.7812 79.6L53.864 76.4962L56.6147 76.1436Z" fill="#CE7A63" />
        <path d="M59.723 53.2801C59.7661 53.4925 59.9139 53.6419 60.0526 53.6135C60.1913 53.5852 60.2688 53.3901 60.2257 53.1777C60.1826 52.9652 60.0348 52.8159 59.8961 52.8443C59.7574 52.8726 59.6795 53.0677 59.723 53.2801Z" fill="#263238" />
        <path d="M59.8906 53.6455C59.8906 53.6455 60.6228 54.7727 61.2745 55.2558C60.9702 55.6829 60.2985 55.6523 60.2985 55.6523L59.8906 53.6455Z" fill="#BA4D3C" />
        <path d="M58.6978 52.2587C58.6668 52.2587 58.6359 52.2474 58.6113 52.2251C58.5595 52.1775 58.5565 52.097 58.6041 52.0452C59.0819 51.5281 59.6621 51.6199 59.6871 51.6241C59.7562 51.6358 59.8031 51.7016 59.791 51.7707C59.7789 51.8399 59.7128 51.886 59.6447 51.8751C59.6255 51.872 59.1722 51.8055 58.7908 52.2179C58.7663 52.2447 58.7322 52.2587 58.6978 52.2587Z" fill="#263238" />
        <path d="M53.82 57.1455C54.2056 59.1115 54.438 61.835 53.0625 63.1466C53.0625 63.1466 53.6 65.1406 57.2526 65.1406C61.2693 65.1406 59.185 63.3905 59.185 63.3905C57.5157 62.8722 57.5301 60.9705 57.9119 59.443L53.82 57.1455Z" fill="#CE7A63" />
        <path d="M48.2506 63.1554C45.732 63.7326 44.0703 70.5294 44.0703 70.5294L48.2752 73.6884C48.2752 73.6884 50.5693 72.2671 51.3952 69.0511C52.2612 65.6812 50.8259 62.565 48.2506 63.1554Z" fill="var(--theme-color)" />
        <path opacity="0.2" d="M50.4126 67.8838C49.0447 69.2374 48.1605 71.3739 48.0547 73.5171L48.2777 73.6891C48.2777 73.6891 50.5737 72.2656 51.4004 69.0507C51.4514 68.8496 51.4956 68.6485 51.5319 68.4508L50.4126 67.8838Z" fill="black" />
        <path d="M64.1727 65.8508C64.7167 68.7266 65.5377 75.5533 64.003 87.1567C63.9766 87.3563 63.8193 87.5143 63.6197 87.54C62.9854 87.6217 61.5146 87.7468 59.6602 87.4886C57.0028 87.1189 54.8191 87.2698 52.2521 87.4724C50.7692 87.5892 49.4939 87.5536 48.8365 87.5196C48.5791 87.5064 48.3894 87.2781 48.423 87.0225C48.8173 84.0356 50.2593 72.9349 48.2578 63.156C48.2578 63.156 50.7212 62.6616 53.069 62.5486C54.9057 62.4601 57.5642 62.4015 59.1786 62.5489C59.8526 62.6105 60.5141 62.7077 61.1034 62.812C62.6573 63.0872 63.879 64.3002 64.1727 65.8508Z" fill="var(--theme-color)" />
        <path d="M52.5439 54.2696C53.2341 56.8456 53.5074 58.3882 55.0969 59.4595C57.4882 61.0705 60.4649 59.2217 60.5583 56.4911C60.6422 54.0337 59.4991 50.2337 56.7348 49.7147C54.0113 49.2036 51.8537 51.6935 52.5439 54.2696Z" fill="#CE7A63" />
        <path d="M58.5784 55.0597C59.3816 56.8344 59.1288 58.4504 58.1278 59.2117C56.9934 60.0746 53.8129 60.2051 52.6083 58.9837C53.0672 58.5279 53.3193 57.9556 52.733 57.1455C52.1467 56.3351 49.9974 55.0684 49.9543 53.3338C49.9109 51.5991 51.0615 51.4037 50.9965 51.4037C49.9762 50.9478 50.0413 49.3175 51.1594 48.4164C52.3486 47.4581 54.2749 47.1954 56.5701 47.6513C58.0186 47.939 59.4376 47.9117 59.19 47C60.8959 47.9768 60.0496 51.6025 58.3996 52.0799C58.66 52.7312 59.8016 53.7734 59.8016 53.7734C59.8016 53.7734 59.5207 54.8643 58.5784 55.0597Z" fill="#263238" />
        <path d="M51.1609 51.0546C51.1609 51.0546 50.5421 51.4454 48.9141 50.957C49.3537 51.7712 50.9817 51.8007 51.3726 51.6151C51.7634 51.4295 51.1609 51.0546 51.1609 51.0546Z" fill="#263238" />
        <path d="M57.5355 54.4077C57.6837 55.0499 58.0874 55.6093 58.5168 55.9477C59.1628 56.4564 59.6686 55.987 59.6421 55.2393C59.6183 54.5664 59.2531 53.491 58.5312 53.2722C57.8198 53.0563 57.3662 53.6732 57.5355 54.4077Z" fill="#CE7A63" />
        <path d="M64.2823 65.4585C64.6191 66.2406 64.9381 67.0295 65.2605 67.8168C65.5864 68.6027 65.9039 69.3912 66.2169 70.1812L68.0865 74.9024C68.4013 75.68 68.7136 76.4579 69.0326 77.2011L69.2738 77.739L69.3339 77.869L69.349 77.9015L69.3528 77.9094L69.3547 77.9136C69.3603 77.9246 69.3486 77.9015 69.3335 77.8747C69.2813 77.7805 69.2178 77.6891 69.1468 77.6063C69.0043 77.4426 68.8417 77.3061 68.6527 77.2071C68.5087 77.1266 68.345 77.0718 68.2157 77.0446C68.1224 77.0223 68.0056 77.0106 67.927 77.009C67.8676 77.0068 67.8079 77.0087 67.7489 77.0151C67.6775 77.0204 67.5985 77.0393 67.5754 77.0453C67.4964 77.0684 67.4934 77.0756 67.4858 77.0816C67.4983 77.0922 67.6646 77.0359 67.8098 76.9678C67.9625 76.8994 68.1303 76.814 68.2997 76.7236C68.985 76.3596 69.7104 75.9344 70.4342 75.514C71.1623 75.096 71.9062 74.6707 72.6546 74.2697L72.6746 74.2591C73.1736 73.9915 73.795 74.1793 74.0626 74.6783C74.2656 75.0574 74.2044 75.5091 73.9455 75.8206C72.8069 77.1814 71.6181 78.4031 70.1738 79.5617C69.9874 79.7057 69.7962 79.8497 69.5811 79.996C69.3581 80.1423 69.1498 80.2923 68.7654 80.4572C68.658 80.4999 68.5541 80.543 68.3711 80.5879C68.2966 80.608 68.164 80.6322 68.0403 80.6446C67.9549 80.6514 67.8684 80.6541 67.7822 80.6526C67.6771 80.6496 67.5338 80.6325 67.414 80.6072C67.2594 80.5732 67.07 80.5082 66.9022 80.4175C66.6935 80.301 66.5038 80.1547 66.3477 79.9673C66.2687 79.8739 66.1976 79.7718 66.1371 79.6668L66.1027 79.6048L66.0816 79.5662L65.9965 79.4116C65.8797 79.203 65.7799 79.006 65.6722 78.8034C65.2609 78.007 64.8871 77.2253 64.5253 76.4394C63.7981 74.8726 63.1139 73.3058 62.4448 71.7325C62.1095 70.9467 61.7814 70.1589 61.4624 69.3674C61.1407 68.5774 60.8168 67.7889 60.511 66.9928C60.1076 65.9427 60.6319 64.7641 61.6824 64.3612C62.7041 63.9695 63.851 64.4617 64.2823 65.4585Z" fill="#CF7A64" />
        <path d="M74.1392 72.7052C74.1392 72.7052 72.7387 73.3652 72.1562 75.2753L73.0929 76.4709L75.1307 75.8388C75.2933 75.7886 75.4339 75.6842 75.5295 75.5436L76.5777 74.001C76.7433 73.6926 76.7161 73.3165 76.507 73.0352L75.3995 71.5459L74.1392 72.7052Z" fill="#CE7A63" />
        <path d="M58.7257 67.343C58.9623 70.3394 62.2626 74.2554 62.2626 74.2554L66.9162 70.7692C66.9162 70.7692 66.2074 66.5518 63.795 64.2657C60.8149 61.4412 58.5038 64.5322 58.7257 67.343Z" fill="var(--theme-color)" />
        <path d="M59.8577 62.5483C59.4257 61.2885 54.469 61.0677 51.4835 61.3716C48.4984 61.6755 50.0036 63.9983 50.5053 64.3242C49.1505 64.8235 49.8751 67.2159 52.385 68.3862C54.8953 69.5557 60.3801 64.0724 59.8577 62.5483Z" fill="#263238" />
        <path d="M97.8253 63.9003V83H95.3316V74.3407H85.6037V83H83.11V63.9003H85.6037V72.2855H95.3316V63.9003H97.8253ZM103.371 65.5445C102.896 65.5445 102.494 65.3801 102.165 65.0512C101.837 64.7224 101.672 64.3205 101.672 63.8455C101.672 63.3705 101.837 62.9686 102.165 62.6398C102.494 62.3109 102.896 62.1465 103.371 62.1465C103.828 62.1465 104.211 62.3109 104.522 62.6398C104.851 62.9686 105.015 63.3705 105.015 63.8455C105.015 64.3205 104.851 64.7224 104.522 65.0512C104.211 65.3801 103.828 65.5445 103.371 65.5445ZM104.577 67.9833V83H102.083V67.9833H104.577Z" fill="black" />
      </svg>
    </>
  )
}

function HiSvgDark() {
  return (
    <>
      <svg width="189" height="189" viewBox="0 0 189 189" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M36 54C36 44.6112 43.6112 37 53 37H138C147.389 37 155 44.6112 155 54V92.2603C155 101.649 147.389 109.26 138 109.26H130.683C127.45 109.26 124.59 111.359 123.619 114.443C122.223 118.881 117.129 120.947 113.035 118.736L99.2824 111.304C96.7999 109.963 94.0225 109.26 91.2008 109.26H53C43.6112 109.26 36 101.649 36 92.2604V54Z" fill="#181818" />
        <path d="M189 144.547H0V144.641H189V144.547Z" fill="#3C3C3C" />
        <path d="M170.067 150.629H157.547V150.723H170.067V150.629Z" fill="#3C3C3C" />
        <path d="M125.2 151.656H121.914V151.751H125.2V151.656Z" fill="#3C3C3C" />
        <path d="M157.161 147.121H149.906V147.216H157.161V147.121Z" fill="#3C3C3C" />
        <path d="M36.1551 147.754H19.8281V147.848H36.1551V147.754Z" fill="#3C3C3C" />
        <path d="M41.9173 147.754H39.5234V147.848H41.9173V147.754Z" fill="#3C3C3C" />
        <path d="M85.1048 149.352H49.6953V149.446H85.1048V149.352Z" fill="#3C3C3C" />
        <path d="M94.4932 161.619C134.97 161.619 167.783 159.703 167.783 157.339C167.783 154.975 134.97 153.059 94.4932 153.059C54.0162 153.059 21.2031 154.975 21.2031 157.339C21.2031 159.703 54.0162 161.619 94.4932 161.619Z" fill="#262626" />
        <path d="M139.977 57.0398C140.911 53.9992 131.362 53.3297 129.06 58.7597C125.835 66.3685 130.536 70.6493 130.536 70.6493C133.277 69.1766 138.636 68.957 141.566 69.9285L139.977 57.0398Z" fill="#263238" />
        <path d="M140.722 154.217L137.776 154.332L137.758 151.146L140.704 151.031L140.722 154.217Z" fill="#FFD5D0" />
        <path d="M137.648 153.723H140.982C141.104 153.723 141.213 153.807 141.246 153.925L141.971 156.563C142.046 156.837 141.845 157.096 141.564 157.091C140.399 157.071 139.83 157.003 138.364 157.003C137.462 157.003 135.131 157.096 133.885 157.096C132.667 157.096 132.412 155.865 132.916 155.753C135.176 155.253 136.479 154.563 137.176 153.905C137.302 153.787 137.471 153.723 137.648 153.723Z" fill="var(--theme-color)" />
        <path opacity="0.2" d="M137.758 151.147L137.766 152.788L140.715 152.804L140.706 151.031L137.758 151.147Z" fill="black" />
        <path d="M131.023 92.1658C130.542 95.7961 132.18 113.01 133.559 120.522C135.391 130.5 137.128 152.126 137.128 152.126L141.101 151.888C141.101 151.888 141.579 128.177 140.363 120.131C140.284 109.58 140.474 91.1055 140.474 91.1055L131.023 92.1658Z" fill="white" />
        <path opacity="0.2" d="M140.385 102.602C140.385 99.9255 138.403 97.8125 137.908 102.922C137.592 106.177 138.859 111.638 140.345 115.417C140.34 111.298 140.361 106.689 140.385 102.602Z" fill="black" />
        <path d="M158.257 154.545L155.552 154.618L154.281 150.933L156.987 150.859L158.257 154.545Z" fill="#FFD5D0" />
        <path d="M158.18 153.719H154.846C154.725 153.719 154.646 153.803 154.657 153.921L154.903 156.559C154.929 156.833 155.225 157.092 155.504 157.087C156.662 157.067 157.205 156.999 158.672 156.999C159.574 156.999 160.764 157.092 162.009 157.092C163.227 157.092 163.029 155.861 162.484 155.749C160.04 155.249 159.659 154.559 158.719 153.901C158.55 153.783 158.358 153.719 158.18 153.719Z" fill="var(--theme-color)" />
        <path opacity="0.2" d="M154.281 150.933L154.936 152.833L157.694 152.911L156.988 150.859L154.281 150.933Z" fill="black" />
        <path d="M135.547 91.6542C135.547 91.6542 141.675 114.088 144.753 120.707C146.75 130.932 153.907 152.36 153.907 152.36L158.057 152.071C158.057 152.071 153.512 130.391 150.73 120.329C149.227 110.973 148.231 95.3809 143.917 90.7148L135.547 91.6542Z" fill="white" />
        <path d="M129.614 75.4775C129.534 77.3679 129.371 79.2027 129.148 81.0572C128.933 82.9071 128.654 84.7529 128.294 86.5926L128.153 87.2821L128.078 87.6457C128.031 87.8404 127.985 88.0358 127.864 88.2925C127.746 88.5378 127.567 88.844 127.208 89.1176C126.853 89.3966 126.345 89.5236 125.991 89.5028C125.63 89.4896 125.378 89.4042 125.166 89.3214C124.954 89.2356 124.8 89.1433 124.648 89.0507C124.083 88.6799 123.72 88.3099 123.361 87.9356C123.015 87.5591 122.702 87.18 122.405 86.7979C121.24 85.2541 120.263 83.6809 119.383 82.0086C119.174 81.6109 119.326 81.1192 119.724 80.9101C120.068 80.7294 120.482 80.819 120.723 81.1037L120.737 81.1199C121.902 82.4947 123.078 83.9043 124.308 85.1449C124.612 85.4556 124.923 85.7527 125.231 86.0184C125.532 86.2804 125.857 86.5287 126.079 86.6342C126.127 86.655 126.174 86.6739 126.178 86.6674C126.18 86.664 126.153 86.6399 126.022 86.6312C125.898 86.6153 125.623 86.6761 125.45 86.813C125.274 86.946 125.222 87.0522 125.198 87.0904C125.176 87.1388 125.181 87.1086 125.183 87.0798L125.227 86.7653L125.321 86.0982C125.561 84.3155 125.751 82.5181 125.925 80.7173C126.083 78.9203 126.229 77.0957 126.349 75.3199L126.351 75.2976C126.412 74.3968 127.191 73.716 128.092 73.7773C128.978 73.837 129.651 74.5953 129.614 75.4775Z" fill="#FFD5D0" />
        <path d="M128.229 72.9654C125.424 74.3353 125.861 77.9724 125.861 77.9724L130.348 81.1332C130.348 81.1332 131.987 77.1831 131.65 75.2878C131.298 73.315 130.307 71.9505 128.229 72.9654Z" fill="var(--theme-color)" />
        <path opacity="0.2" d="M127.737 76.0016C128.398 74.9667 129.526 75.2177 130.842 76.0417C131.122 76.2727 131.373 76.5921 131.589 76.9754C131.273 78.8926 130.341 81.1364 130.341 81.1364L127.178 78.9088C127.027 78.1211 127.266 76.7376 127.737 76.0016Z" fill="black" />
        <path d="M120.93 81.611L120.262 79.0508L117.992 81.092C117.992 81.092 118.812 82.4607 120.129 82.6467L120.93 81.611Z" fill="#FFD5D0" />
        <path d="M118.525 78.0089L118.063 78.4663C117.34 79.1815 117.309 80.3393 117.993 81.0923L120.263 79.0511L119.628 78.1166C119.375 77.7439 118.846 77.6922 118.525 78.0089Z" fill="#FFD5D0" />
        <path d="M119.679 78.1821C119.092 77.4416 118.271 76.0544 118.127 75.766C117.983 75.4776 117.517 75.8771 117.739 76.2986C117.961 76.7204 118.393 78.085 118.848 78.5843C119.303 79.0837 119.679 78.1821 119.679 78.1821Z" fill="#FFD5D0" />
        <path d="M127.192 75.0276C127.986 82.3305 130.369 87.423 131.021 92.1638L143.926 90.7157C143.195 85.9737 142.823 82.8688 143.731 74.0792C143.898 72.4636 142.645 71.0529 141.021 71.028C140.236 71.0159 139.364 71.0261 138.49 71.0816C136.307 71.2208 134.52 71.3512 132.63 71.7394C131.27 72.0187 129.822 72.4152 128.787 72.7176C127.776 73.0132 127.078 73.9798 127.192 75.0276Z" fill="var(--theme-color)" />
        <path d="M132.632 71.7398C132.632 71.7398 130.562 73.9809 133.65 77.0435C135.558 73.1818 138.492 71.082 138.492 71.082L132.632 71.7398Z" fill="white" />
        <path d="M137.173 64.5469C137.015 66.4739 137.033 69.97 138.494 71.0802C138.494 71.0802 135.267 72.836 133.528 75.9209C131.253 73.6351 132.634 71.7379 132.634 71.7379C134.68 71.0001 134.451 69.4461 133.92 68.0222L137.173 64.5469Z" fill="#FFD5D0" />
        <path opacity="0.2" d="M136.82 64.9258C136.856 65.4856 136.936 66.767 136.4 68.2499C136.137 68.9813 135.24 69.4021 134.285 69.5793C134.266 69.0739 134.114 68.5398 133.922 68.022L136.82 64.9258Z" fill="black" />
        <path d="M139.91 61.8539C139.348 64.9769 139.176 66.3109 137.397 67.739C134.722 69.8868 131.009 68.5124 130.628 65.2839C130.284 62.3782 131.262 57.759 134.489 56.8688C137.668 55.9922 140.474 58.7308 139.91 61.8539Z" fill="#FFD5D0" />
        <path d="M137.496 59.3483C136.74 61.0179 137.402 63.8529 139.797 63.6794C137.86 65.8926 138.322 70.7416 138.322 70.7416C139.612 70.8478 140.753 70.5329 141.813 69.9928C141.813 69.9928 141.058 65.408 141.856 62.1901C142.505 59.5732 142.409 54.4971 136.74 55.5997C136.079 55.7282 131.77 56.8599 131.336 59.1234C131.299 59.3158 135.934 60.6577 137.496 59.3483Z" fill="#263238" />
        <path d="M140.603 63.6235C140.463 64.2661 140.038 64.784 139.579 65.0682C138.887 65.4957 138.316 64.9318 138.32 64.161C138.324 63.4674 138.688 62.409 139.473 62.2933C140.246 62.1795 140.764 62.8887 140.603 63.6235Z" fill="#FFD5D0" />
        <path opacity="0.2" d="M141.693 76.1837C141.552 77.2928 142.105 78.6804 143.279 79.5075C143.347 78.2011 143.463 76.7352 143.627 75.0494C142.97 74.3414 141.85 74.9571 141.693 76.1837Z" fill="black" />
        <path d="M144.034 89.9387L144.746 91.0285C144.801 91.1132 144.705 91.2164 144.556 91.233L131.022 92.7514C130.905 92.7647 130.803 92.7182 130.787 92.646L130.541 91.504C130.524 91.425 130.617 91.3457 130.744 91.3317L143.813 89.8654C143.909 89.8548 143.999 89.8843 144.034 89.9387Z" fill="#263238" />
        <path d="M142.44 91.5948L142.79 91.5555C142.859 91.5476 142.908 91.5056 142.898 91.4625L142.566 89.98C142.556 89.9365 142.491 89.9074 142.421 89.9154L142.071 89.9547C142.002 89.9626 141.953 90.0046 141.962 90.0477L142.295 91.5302C142.305 91.5737 142.37 91.6028 142.44 91.5948Z" fill="var(--theme-color)" />
        <path d="M132.017 92.7628L132.367 92.7235C132.437 92.7155 132.486 92.6736 132.476 92.6305L132.144 91.148C132.134 91.1045 132.069 91.0754 131.999 91.0833L131.649 91.1226C131.58 91.1306 131.53 91.1725 131.54 91.2156L131.873 92.6982C131.883 92.7416 131.948 92.7707 132.017 92.7628Z" fill="var(--theme-color)" />
        <path d="M137.236 92.1808L137.586 92.1414C137.655 92.1335 137.704 92.0915 137.695 92.0485L137.362 90.5659C137.353 90.5225 137.288 90.4934 137.218 90.5013L136.868 90.5406C136.798 90.5486 136.749 90.5905 136.759 90.6336L137.092 92.1161C137.101 92.1596 137.166 92.1887 137.236 92.1808Z" fill="var(--theme-color)" />
        <path d="M134.58 62.1726C134.55 62.4289 134.39 62.6205 134.222 62.6009C134.055 62.5812 133.943 62.3574 133.974 62.1015C134.004 61.8452 134.164 61.6536 134.331 61.6733C134.499 61.6925 134.61 61.9163 134.58 62.1726Z" fill="#263238" />
        <path d="M131.689 61.8328C131.659 62.089 131.499 62.2807 131.332 62.261C131.164 62.2414 131.053 62.0176 131.083 61.7617C131.113 61.5054 131.273 61.3138 131.441 61.3334C131.608 61.3531 131.719 61.5768 131.689 61.8328Z" fill="#263238" />
        <path d="M131.508 61.3549L130.914 61.1055C130.914 61.1055 131.173 61.6229 131.508 61.3549Z" fill="#263238" />
        <path d="M132.394 62.3633C132.394 62.3633 131.83 63.4149 131.289 63.8908C131.59 64.2461 132.182 64.1694 132.182 64.1694L132.394 62.3633Z" fill="#FFD4D0" />
        <path d="M132.903 65.059C132.878 65.0435 132.863 65.014 132.868 64.983C132.874 64.9418 132.913 64.9131 132.954 64.9195C134.07 65.0896 134.715 64.3877 134.721 64.3809C134.749 64.3499 134.796 64.3465 134.828 64.3748C134.859 64.4028 134.862 64.4504 134.834 64.4818C134.806 64.5132 134.131 65.2522 132.931 65.0696C132.921 65.0677 132.911 65.0639 132.903 65.059Z" fill="#263238" />
        <path d="M135.948 60.8243C135.926 60.8115 135.907 60.7933 135.893 60.7695C135.551 60.187 134.994 60.1545 134.988 60.1542C134.904 60.1504 134.84 60.0789 134.844 59.9958C134.848 59.9122 134.919 59.8476 135.002 59.8518C135.032 59.8533 135.73 59.8941 136.154 60.6164C136.196 60.6886 136.172 60.7813 136.1 60.824C136.051 60.8519 135.993 60.8504 135.948 60.8243Z" fill="#263238" />
        <path d="M130.913 60.3243C130.904 60.3198 130.897 60.3141 130.889 60.308C130.825 60.254 130.818 60.1584 130.872 60.0945C131.415 59.456 132.109 59.5365 132.139 59.5403C132.221 59.5513 132.28 59.6269 132.27 59.7097C132.259 59.7925 132.184 59.851 132.101 59.8408C132.075 59.8378 131.535 59.7826 131.103 60.2907C131.055 60.347 130.975 60.3595 130.913 60.3243Z" fill="#263238" />
        <path d="M143.582 73.0234C144.694 74.1484 145.748 75.2914 146.777 76.4905C147.289 77.0896 147.806 77.6891 148.297 78.3237C148.79 78.9656 149.279 79.5904 149.748 80.3733C149.867 80.5759 149.985 80.7811 150.109 81.062C150.171 81.2064 150.238 81.3655 150.299 81.6282C150.314 81.7027 150.327 81.7567 150.337 81.8656L150.348 82.0115C150.35 82.061 150.348 82.1442 150.343 82.2088L150.333 82.312L150.326 82.3589L150.324 82.3684L150.315 82.4069L150.298 82.4836C150.2 82.8923 150.129 83.3009 149.999 83.7042C149.779 84.5143 149.473 85.3103 149.113 86.0811C148.734 86.8476 148.284 87.5878 147.73 88.2587C147.46 88.5982 147.147 88.91 146.819 89.2045C146.652 89.3504 146.479 89.4914 146.296 89.6248C146.203 89.6921 146.107 89.7545 146.007 89.8168C145.899 89.8822 145.819 89.9299 145.658 90.0138L144.841 88.6156C144.845 88.5974 144.921 88.5286 144.966 88.4765L145.124 88.2977C145.23 88.1737 145.332 88.0421 145.43 87.9061C145.623 87.6297 145.801 87.3398 145.964 87.0374C146.287 86.433 146.548 85.7889 146.763 85.1266C146.856 84.7864 146.965 84.4576 147.034 84.109C147.124 83.77 147.185 83.4203 147.245 83.0707C147.313 82.7248 147.34 82.3634 147.395 82.0134L147.404 81.9473L147.409 81.9144L147.41 81.9061L147.405 81.9348L147.397 82.0017C147.392 82.0421 147.394 82.1011 147.394 82.1264C147.394 82.151 147.395 82.1756 147.398 82.2001L147.411 82.295C147.426 82.3699 147.421 82.3479 147.401 82.3169C147.362 82.247 147.281 82.1196 147.194 81.9949C146.824 81.4759 146.343 80.8896 145.857 80.3336C145.364 79.7738 144.866 79.203 144.351 78.6443L141.234 75.2979L143.582 73.0234Z" fill="#FFD5D0" />
        <path d="M146.503 89.4931L144.232 91.6005L142.766 89.1877C142.766 89.1877 144.176 88.1716 145.449 88.5553L146.503 89.4931Z" fill="#FFD5D0" />
        <path d="M142.511 92.0444L141.77 91.2536C141.474 90.9373 141.484 90.4425 141.794 90.1389L142.764 89.1875L144.23 91.6003L143.598 92.1166C143.273 92.382 142.798 92.3506 142.511 92.0444Z" fill="#FFD5D0" />
        <path d="M138.467 72.9227C138.294 74.2714 141.891 78.2056 141.891 78.2056L145.252 73.9936C145.252 73.9936 143.683 71.7944 142.487 71.2943C140.561 70.4887 138.665 71.3835 138.467 72.9227Z" fill="var(--theme-color)" />
        <path d="M134.407 61.6948L133.812 61.4453C133.812 61.4453 134.072 61.9628 134.407 61.6948Z" fill="#263238" />
        <path d="M143.689 38.4317C147.708 38.4317 150.977 41.7007 150.977 45.7188V101.242C150.977 105.26 147.708 108.529 143.689 108.529H125.204C122.073 108.529 119.534 111.068 119.534 114.199V119.577L108.228 109.893C107.201 109.013 105.892 108.53 104.54 108.53H45.3165C41.2983 108.53 38.0294 105.261 38.0294 101.242V45.7184C38.0294 41.7003 41.2983 38.4313 45.3165 38.4313L143.689 38.4317ZM143.689 32.7617H45.3165C38.19 32.7617 32.3594 38.5924 32.3594 45.7188V101.242C32.3594 108.369 38.19 114.199 45.3165 114.199H104.54L125.204 131.898V114.199H143.689C150.816 114.199 156.647 108.369 156.647 101.242V45.7184C156.647 38.5924 150.816 32.7617 143.689 32.7617Z" fill="var(--theme-color)" />
        <path d="M58.4508 155.011C58.7955 155.011 59.127 154.963 59.2329 154.808C59.2699 154.754 59.2971 154.662 59.217 154.53C59.1724 154.456 59.1025 154.406 59.0099 154.381C58.5581 154.26 57.6392 154.795 57.6003 154.818C57.578 154.831 57.5663 154.857 57.5716 154.883C57.5769 154.909 57.5977 154.93 57.6241 154.935C57.7965 154.97 58.1295 155.011 58.4508 155.011ZM58.8575 154.49C58.9025 154.49 58.9441 154.495 58.9811 154.504C59.0405 154.52 59.0824 154.549 59.1093 154.594C59.1573 154.673 59.1422 154.712 59.127 154.734C59.0087 154.908 58.3295 154.912 57.8275 154.841C58.0713 154.714 58.5434 154.49 58.8575 154.49Z" fill="var(--theme-color)" />
        <path d="M57.6365 154.936C57.6456 154.936 57.6543 154.934 57.6622 154.93C57.9813 154.784 58.6016 154.203 58.5411 153.899C58.5267 153.828 58.4731 153.739 58.2973 153.721C58.1661 153.708 58.0497 153.745 57.9484 153.831C57.6173 154.111 57.5723 154.835 57.5704 154.866C57.5693 154.888 57.5798 154.911 57.5987 154.924C57.6105 154.931 57.6237 154.936 57.6365 154.936ZM58.2512 153.846C58.2636 153.846 58.2765 153.847 58.2893 153.848C58.4043 153.86 58.4133 153.905 58.4164 153.919C58.4526 154.102 58.0334 154.559 57.7099 154.757C57.7363 154.546 57.8157 154.113 58.0334 153.929C58.0988 153.873 58.1703 153.846 58.2512 153.846Z" fill="var(--theme-color)" />
        <path d="M54.6875 154.871H57.3747L57.4072 148.648H54.7204L54.6875 154.871Z" fill="#EFB3A2" />
        <path d="M57.3381 154.562H54.4036C54.2936 154.562 54.2014 154.639 54.1818 154.746L53.741 157.135C53.6953 157.382 53.8922 157.617 54.1455 157.613C55.2035 157.594 56.7306 157.532 58.0612 157.532C59.617 157.532 59.8083 157.617 61.6325 157.617C62.7355 157.617 62.9997 156.502 62.534 156.401C60.4146 155.941 59.8518 155.892 57.9927 154.772C57.7913 154.65 57.5698 154.562 57.3381 154.562Z" fill="#263238" />
        <path opacity="0.2" d="M57.4077 148.652L57.3915 151.86H54.7031L54.7194 148.652H57.4077Z" fill="black" />
        <path d="M36.8836 154.082C36.8643 153.737 36.7985 153.404 36.6371 153.291C36.5808 153.252 36.4867 153.221 36.3593 153.295C36.2878 153.336 36.2413 153.404 36.2217 153.496C36.1249 153.942 36.7123 154.884 36.7373 154.924C36.7516 154.947 36.7785 154.96 36.8046 154.956C36.8307 154.952 36.8503 154.932 36.8541 154.906C36.8787 154.735 36.9013 154.404 36.8836 154.082ZM36.3389 153.653C36.3362 153.608 36.3385 153.567 36.3464 153.53C36.3593 153.471 36.3861 153.431 36.4285 153.406C36.5048 153.361 36.5453 153.378 36.5687 153.395C36.7494 153.521 36.791 154.2 36.7482 154.699C36.6065 154.449 36.3563 153.967 36.3389 153.653Z" fill="var(--theme-color)" />
        <path d="M36.8638 154.894C36.8634 154.885 36.8607 154.876 36.8566 154.868C36.6929 154.543 36.076 153.897 35.7747 153.944C35.704 153.955 35.6179 154.005 35.6099 154.18C35.6039 154.31 35.6474 154.428 35.7384 154.534C36.0382 154.877 36.7662 154.954 36.7972 154.957C36.8199 154.96 36.8415 154.95 36.8535 154.932C36.8611 154.92 36.8645 154.907 36.8638 154.894ZM35.7377 154.232C35.7369 154.219 35.7369 154.206 35.7377 154.193C35.743 154.079 35.7876 154.072 35.8023 154.07C35.983 154.041 36.4642 154.481 36.6816 154.813C36.4684 154.777 36.0295 154.679 35.8329 154.453C35.7732 154.385 35.7422 154.312 35.7377 154.232Z" fill="var(--theme-color)" />
        <path d="M36.8203 154.914L39.4538 155.099L40.5395 148.826L37.9059 148.641L36.8203 154.914Z" fill="#EFB3A2" />
        <path d="M36.7921 154.31L39.6993 154.052C39.8081 154.042 39.9136 154.11 39.9533 154.214L40.8367 156.547C40.9281 156.788 40.7769 157.039 40.5252 157.057C39.474 157.132 37.9491 157.205 36.631 157.323C35.0899 157.46 36.0931 157.456 34.2859 157.617C33.1931 157.714 32.7229 156.63 33.1651 156.489C35.1788 155.846 35.5231 155.401 36.182 154.576C36.3226 154.4 36.5622 154.331 36.7921 154.31Z" fill="#263238" />
        <path opacity="0.2" d="M40.5375 148.827L39.9784 152.06L37.3438 151.874L37.9024 148.641L40.5375 148.827Z" fill="black" />
        <path d="M58.3681 86.5199C58.3681 86.5199 53.4628 107.16 51.5909 114.822C49.5414 123.212 41.49 151.047 41.49 151.047L36.6875 150.006C36.6875 150.006 41.9028 126.09 43.9553 114.389C45.5319 105.402 49.0938 86.5195 49.0938 86.5195H58.3681V86.5199Z" fill="white" />
        <path d="M42.2296 149.584C42.2515 149.586 41.878 151.434 41.878 151.434L36.1411 150.822L36.0625 149.129L42.2296 149.584Z" fill="var(--theme-color)" />
        <path opacity="0.3" d="M55.535 96.0881C52.1428 96.5391 51.5176 108.459 51.4375 115.453C51.4889 115.232 51.5441 115.022 51.5913 114.823C52.6127 110.64 54.5382 102.579 56.0771 96.1263C55.9134 96.073 55.7301 96.0613 55.535 96.0881Z" fill="black" />
        <path d="M63.4681 86.5195C63.4681 86.5195 62.1538 106.622 61.5698 114.805C60.9623 123.317 58.5291 151.237 58.5291 151.237H53.9769C53.9769 151.237 53.4938 123.826 53.3611 115.455C53.2167 106.33 54.02 86.5195 54.02 86.5195H63.4681Z" fill="white" />
        <path d="M59.1709 149.426C59.192 149.426 58.9853 151.316 58.9853 151.316H53.4479L53.2344 149.629L59.1709 149.426Z" fill="var(--theme-color)" />
        <path d="M50.7571 67.1764C50.0231 68.6601 49.2818 70.2212 48.5905 71.7555C47.8998 73.2951 47.2281 74.8464 46.6868 76.3928L46.4823 76.9712L46.3009 77.5465L46.2174 77.8081C46.2177 77.7816 46.2242 77.7226 46.2128 77.6228C46.2136 77.4142 46.0136 77.0487 45.8692 76.9662C45.7248 76.8661 45.7207 76.9073 45.7778 76.9375C45.8397 76.9731 45.9622 77.0146 46.1036 77.0479C46.3912 77.1125 46.7568 77.1639 47.1351 77.1874C48.6736 77.2743 50.4192 77.1568 52.0919 77.0418L52.1376 77.0388C52.6978 77.0003 53.1828 77.4233 53.2213 77.9835C53.2527 78.4393 52.9771 78.8457 52.5723 79.0018C50.8577 79.6614 49.1624 80.169 47.2217 80.3853C46.7311 80.4302 46.2242 80.4658 45.6492 80.4159C45.3601 80.3902 45.0539 80.3494 44.7016 80.2515C44.3489 80.1433 43.9373 80.0042 43.4701 79.6096C43.2417 79.4127 43.0119 79.1447 42.8483 78.8151C42.6842 78.4877 42.5988 78.1305 42.5765 77.8096C42.5561 77.492 42.5889 77.2161 42.6377 76.9776L42.7216 76.6087L42.8815 75.9249L43.0611 75.2566C43.554 73.4803 44.1826 71.799 44.8596 70.1415C45.5547 68.4858 46.2918 66.8956 47.1499 65.2861C47.6787 64.2934 48.9125 63.9177 49.9048 64.4469C50.8781 64.9659 51.2584 66.1619 50.7738 67.1439L50.7571 67.1764Z" fill="#EFB3A2" />
        <path d="M52.1919 77.1542L53.8634 76.4961L53.7807 79.5999C53.7807 79.5999 52.7449 79.5568 51.9031 78.9622C51.6192 78.7614 51.5017 78.3963 51.5928 78.061L51.685 77.7204C51.7546 77.4623 51.9428 77.2521 52.1919 77.1542Z" fill="#EFB3A2" />
        <path d="M56.6147 76.1445L56.013 78.8363L53.7812 79.601L53.864 76.4972L56.6147 76.1445Z" fill="#EFB3A2" />
        <path d="M59.723 53.2791C59.7661 53.4916 59.9139 53.6409 60.0526 53.6125C60.1913 53.5842 60.2688 53.3891 60.2257 53.1767C60.1826 52.9643 60.0348 52.8149 59.8961 52.8433C59.7574 52.8716 59.6795 53.0667 59.723 53.2791Z" fill="#263238" />
        <path d="M59.8906 53.6445C59.8906 53.6445 60.6228 54.7717 61.2745 55.2548C60.9702 55.6819 60.2985 55.6513 60.2985 55.6513L59.8906 53.6445Z" fill="#EFB3A2" />
        <path d="M58.6978 52.2607C58.6668 52.2607 58.6359 52.2493 58.6113 52.227C58.5595 52.1794 58.5565 52.0989 58.6041 52.0471C59.0819 51.53 59.6621 51.6219 59.6871 51.626C59.7562 51.6377 59.8031 51.7035 59.791 51.7727C59.7789 51.8419 59.7128 51.888 59.6447 51.877C59.6255 51.874 59.1722 51.8075 58.7908 52.2199C58.7663 52.2467 58.7322 52.2607 58.6978 52.2607Z" fill="#263238" />
        <path d="M53.82 57.1445C54.2056 59.1105 54.438 61.834 53.0625 63.1457C53.0625 63.1457 53.6 65.1396 57.2526 65.1396C61.2693 65.1396 59.185 63.3895 59.185 63.3895C57.5157 62.8712 57.5301 60.9695 57.9119 59.442L53.82 57.1445Z" fill="#EFB3A2" />
        <path d="M48.2506 63.1544C45.732 63.7316 44.0703 70.5284 44.0703 70.5284L48.2752 73.6874C48.2752 73.6874 50.5693 72.2661 51.3952 69.0501C52.2612 65.6802 50.8259 62.564 48.2506 63.1544Z" fill="var(--theme-color)" />
        <path opacity="0.2" d="M50.4126 67.8828C49.0447 69.2364 48.1605 71.3729 48.0547 73.5161L48.2777 73.6881C48.2777 73.6881 50.5737 72.2646 51.4004 69.0497C51.4514 68.8486 51.4956 68.6475 51.5319 68.4498L50.4126 67.8828Z" fill="black" />
        <path d="M64.1727 65.8488C64.7167 68.7246 65.5377 75.5513 64.003 87.1548C63.9766 87.3544 63.8193 87.5124 63.6197 87.5381C62.9854 87.6197 61.5146 87.7448 59.6602 87.4867C57.0028 87.117 54.8191 87.2678 52.2521 87.4704C50.7692 87.5872 49.4939 87.5517 48.8365 87.5177C48.5791 87.5044 48.3894 87.2761 48.423 87.0206C48.8173 84.0336 50.2593 72.9329 48.2578 63.154C48.2578 63.154 50.7212 62.6596 53.069 62.5466C54.9057 62.4582 57.5642 62.3996 59.1786 62.547C59.8526 62.6086 60.5141 62.7057 61.1034 62.8101C62.6573 63.0853 63.879 64.2983 64.1727 65.8488Z" fill="var(--theme-color)" />
        <path d="M52.5439 54.2705C53.2341 56.8466 53.5074 58.3892 55.0969 59.4605C57.4882 61.0715 60.4649 59.2227 60.5583 56.492C60.6422 54.0347 59.4991 50.2346 56.7348 49.7156C54.0113 49.2046 51.8537 51.6945 52.5439 54.2705Z" fill="#EFB3A2" />
        <path d="M58.5784 55.0597C59.3816 56.8344 59.1288 58.4504 58.1278 59.2117C56.9934 60.0746 53.8129 60.2051 52.6083 58.9837C53.0672 58.5279 53.3193 57.9556 52.733 57.1455C52.1467 56.3351 49.9974 55.0684 49.9543 53.3338C49.9109 51.5991 51.0615 51.4037 50.9965 51.4037C49.9762 50.9478 50.0413 49.3175 51.1594 48.4164C52.3486 47.4581 54.2749 47.1954 56.5701 47.6513C58.0186 47.939 59.4376 47.9117 59.19 47C60.8959 47.9768 60.0496 51.6025 58.3996 52.0799C58.66 52.7312 59.8016 53.7734 59.8016 53.7734C59.8016 53.7734 59.5207 54.8643 58.5784 55.0597Z" fill="#263238" />
        <path d="M51.1609 51.0546C51.1609 51.0546 50.5421 51.4454 48.9141 50.957C49.3537 51.7712 50.9817 51.8007 51.3726 51.6151C51.7634 51.4295 51.1609 51.0546 51.1609 51.0546Z" fill="#263238" />
        <path d="M57.5355 54.4096C57.6837 55.0519 58.0874 55.6113 58.5168 55.9496C59.1628 56.4584 59.6686 55.9889 59.6421 55.2412C59.6183 54.5684 59.2531 53.493 58.5312 53.2741C57.8198 53.0583 57.3662 53.6752 57.5355 54.4096Z" fill="#EFB3A2" />
        <path d="M64.2823 65.4585C64.6191 66.2406 64.9381 67.0295 65.2605 67.8168C65.5864 68.6027 65.9039 69.3912 66.2169 70.1812L68.0865 74.9024C68.4013 75.68 68.7136 76.4579 69.0326 77.2011L69.2738 77.739L69.3339 77.869L69.349 77.9015L69.3528 77.9094L69.3547 77.9136C69.3603 77.9246 69.3486 77.9015 69.3335 77.8747C69.2813 77.7805 69.2178 77.6891 69.1468 77.6063C69.0043 77.4426 68.8417 77.3061 68.6527 77.2071C68.5087 77.1266 68.345 77.0718 68.2157 77.0446C68.1224 77.0223 68.0056 77.0106 67.927 77.009C67.8676 77.0068 67.8079 77.0087 67.7489 77.0151C67.6775 77.0204 67.5985 77.0393 67.5754 77.0453C67.4964 77.0684 67.4934 77.0756 67.4858 77.0816C67.4983 77.0922 67.6646 77.0359 67.8098 76.9678C67.9625 76.8994 68.1303 76.814 68.2997 76.7236C68.985 76.3596 69.7104 75.9344 70.4342 75.514C71.1623 75.096 71.9062 74.6707 72.6546 74.2697L72.6746 74.2591C73.1736 73.9915 73.795 74.1793 74.0626 74.6783C74.2656 75.0574 74.2044 75.5091 73.9455 75.8206C72.8069 77.1814 71.6181 78.4031 70.1738 79.5617C69.9874 79.7057 69.7962 79.8497 69.5811 79.996C69.3581 80.1423 69.1498 80.2923 68.7654 80.4572C68.658 80.4999 68.5541 80.543 68.3711 80.5879C68.2966 80.608 68.164 80.6322 68.0403 80.6446C67.9549 80.6514 67.8684 80.6541 67.7822 80.6526C67.6771 80.6496 67.5338 80.6325 67.414 80.6072C67.2594 80.5732 67.07 80.5082 66.9022 80.4175C66.6935 80.301 66.5038 80.1547 66.3477 79.9673C66.2687 79.8739 66.1976 79.7718 66.1371 79.6668L66.1027 79.6048L66.0816 79.5662L65.9965 79.4116C65.8797 79.203 65.7799 79.006 65.6722 78.8034C65.2609 78.007 64.8871 77.2253 64.5253 76.4394C63.7981 74.8726 63.1139 73.3058 62.4448 71.7325C62.1095 70.9467 61.7814 70.1589 61.4624 69.3674C61.1407 68.5774 60.8168 67.7889 60.511 66.9928C60.1076 65.9427 60.6319 64.7641 61.6824 64.3612C62.7041 63.9695 63.851 64.4617 64.2823 65.4585Z" fill="#EFB3A2" />
        <path d="M74.1392 72.7062C74.1392 72.7062 72.7387 73.3662 72.1562 75.2762L73.0929 76.4718L75.1307 75.8398C75.2933 75.7896 75.4339 75.6852 75.5295 75.5446L76.5777 74.002C76.7433 73.6935 76.7161 73.3174 76.507 73.0362L75.3995 71.5469L74.1392 72.7062Z" fill="#EFB3A2" />
        <path d="M58.7257 67.343C58.9623 70.3394 62.2626 74.2554 62.2626 74.2554L66.9162 70.7692C66.9162 70.7692 66.2074 66.5518 63.795 64.2657C60.8149 61.4412 58.5038 64.5322 58.7257 67.343Z" fill="var(--theme-color)" />
        <path d="M59.8577 62.5483C59.4257 61.2885 54.469 61.0677 51.4835 61.3716C48.4984 61.6755 50.0036 63.9983 50.5053 64.3242C49.1505 64.8235 49.8751 67.2159 52.385 68.3862C54.8953 69.5557 60.3801 64.0724 59.8577 62.5483Z" fill="#263238" />
        <path d="M97.8253 63.9003V83H95.3316V74.3407H85.6037V83H83.11V63.9003H85.6037V72.2855H95.3316V63.9003H97.8253ZM103.371 65.5445C102.896 65.5445 102.494 65.3801 102.165 65.0512C101.837 64.7224 101.672 64.3205 101.672 63.8455C101.672 63.3705 101.837 62.9686 102.165 62.6398C102.494 62.3109 102.896 62.1465 103.371 62.1465C103.828 62.1465 104.211 62.3109 104.522 62.6398C104.851 62.9686 105.015 63.3705 105.015 63.8455C105.015 64.3205 104.851 64.7224 104.522 65.0512C104.211 65.3801 103.828 65.5445 103.371 65.5445ZM104.577 67.9833V83H102.083V67.9833H104.577Z" fill="white" />
      </svg>
    </>
  )
}
