import React from "react";
import Profile from "./Profile";
import RightSideOptions from "./RightSideOptions";
import PinMessages from "./PinMessages/PinMessages";
import Skeleton from "react-loading-skeleton";
import "react-loading-skeleton/dist/skeleton.css";
import { useAppSelector } from "../../../utils/hooks";
import { useTheme } from "../../../context/ThemeProvider";

export default function MessageHeader() {
  const pinMessageCount = useAppSelector(
    (state) => state.MessageList.pinned_messages.Records.length,
  );
  const messageListDetails = useAppSelector((state) => state.MessageOptions);
  // @ts-ignore
  const { theme } = useTheme();

  return (
    <div className="relative">
      <div className="relative flex h-20 w-full items-center justify-between border-b border-borderColor bg-messageHead p-5 px-2 lg:px-10 2xl:h-24">
        <Profile />
        <RightSideOptions />

        {/* Shimmer loader using react-loading-skeleton */}
        {messageListDetails.isMoreMessageLoading && (
          <div className="absolute -bottom-2 left-0 w-full">
            <div className="relative z-10">
              <Skeleton
                baseColor={theme == "dark" ? "transparent" : "transparent"}
                highlightColor={theme == "dark" ? "#FCC604" : "#FCC604"}
                height={4}
                width={"100%"}
                borderRadius={0}
                duration={1}
              />
            </div>
          </div>
        )}
      </div>

      {pinMessageCount !== 0 && <PinMessages />}
    </div>
  );
}
