// components/MyMessage.tsx
import React from "react";
import { Message } from "../../../types/MessageListType";
import GoogleMapReact from "google-map-react";
import { formatTimeOnly } from "../../../utils/formatUTCtoLocalDate";
import { LiaCheckDoubleSolid } from "react-icons/lia";
import { useAppDispatch, useAppSelector } from "../../../utils/hooks";
import { setViewImage } from "../../../store/Slices/ViewManagerSlice";
import { FaPlay, FaSquareCheck } from "react-icons/fa6";
import { IoSquareOutline } from "react-icons/io5";
import {
  addMessage,
  removeMessage,
  updateMessageOptions,
} from "../../../store/Slices/MessageOptionsSlice";
import LinkPreview from "../../../components/LinkPreview";
import { useTheme } from "../../../context/ThemeProvider";
import LoadingSkeletonImageDynamic from "../../../components/LoadingSkeletonImageDynamic";
// @ts-ignore
import { AudioPlayer } from "react-audio-player-component";
import SelectedMessageOption from "./SelectedMessageOption/SelectedMessageOption";
import ShowReplyMessage from "./ReplyMessage/ShowReplyMessage";
import { MdLocationPin } from "react-icons/md";
import ShowSavedName from "../../../components/ShowSavedName";
import { getRandomColor } from "../../../utils/getRandomColor";
import CallInMessageList from "./CallInMessageList";
import PinIcon from "/MessageListIcons/pin 1.png";
import PinDarkIcon from "/MessageListIcons/pin_dark.png";
import ShowStatusReply from "./ShowStatusReply";
import { RiArrowGoForwardLine } from "react-icons/ri";

interface MyMessageProps {
  messageData: Message;
  image_urls: string[];
}

const MyMessage: React.FC<MyMessageProps> = ({ messageData, image_urls }) => {
  const dispatch = useAppDispatch();
  const MessageOptions = useAppSelector((state) => state.MessageOptions);
  const userData = useAppSelector((state) => state.userData);
  const currentConversationData = useAppSelector(
    (state) => state.CurrentConversation,
  );

  const defaultProps = {
    center: {
      lat: 10.99835602,
      lng: 77.01502627,
    },
    zoom: 11,
  };
  // @ts-ignore
  const { theme } = useTheme();

  const isMessageSelected = MessageOptions.message_list?.Records?.some(
    (message) => message.message_id === messageData.message_id,
  );

  const handleImageClick = (imageIndex: number) => {
    dispatch(
      setViewImage({
        show_image: true,
        image_src: image_urls,
        currentIndex: imageIndex,
      }),
    );
  };
  const imageIndex = image_urls.indexOf(
    messageData.message_content.replace(/\\/g, "/"),
  );

  const handleSelectMessageClick = () => {
    if (MessageOptions.selectMessage) {
      if (isMessageSelected) {
        dispatch(removeMessage(messageData.message_id));
      } else if (messageData.User.user_id == userData.user_id) {
        dispatch(addMessage(messageData));
      } else {
        // Dispatch the first action
        dispatch(
          updateMessageOptions({
            delete_only_from_me: true,
          }),
        );
        // Dispatch the second action
        dispatch(addMessage(messageData));
      }
    }
  };

  // Regex to check if the message contains only emojis
  const isOnlyEmojis = (message: string) => {
    return (
      message &&
      message
        .trim()
        .match(
          /^(?:\p{Emoji_Presentation}|\p{Emoji}\uFE0F|\p{Emoji_Modifier_Base})+$/u,
        )
    );
  };

  return (
    <div
      key={messageData.message_id}
      id={String(messageData.message_id)}
      className={`my-2 flex flex-col rounded-lg ${MessageOptions.selectMessage && isMessageSelected
        ? "bg-selectedMessage"
        : ""
        }`}
    >
      {/* {messageData.delete_from_everyone} */}
      <div className="flex items-end justify-end">
        {messageData.message_type == "call" ||
          messageData.deleted_for_everyone ||
          (messageData.deleted_for.includes(userData.user_id)
            ? ""
            : MessageOptions.selectMessage &&
            (isMessageSelected ? (
              <FaSquareCheck
                onClick={() =>
                  dispatch(removeMessage(messageData.message_id))
                }
                className="mx-5 my-auto h-5 w-5 cursor-pointer text-themeColor"
              />
            ) : (
              <IoSquareOutline
                onClick={() => dispatch(addMessage(messageData))}
                className="mx-5 my-auto h-5 w-5 cursor-pointer text-[#BDBDBD]"
              />
            )))}

        <div
          onClick={() => {
            if (
              messageData.message_type == "call" ||
              messageData.deleted_for_everyone ||
              messageData.deleted_for.includes(userData.user_id)
            )
              return;

            handleSelectMessageClick();
          }}
          className={`mx-2 flex w-full flex-col group/forward space-y-2 ${MessageOptions.selectMessage ? "cursor-pointer" : ""
            } ${messageData?.User?.user_id == userData?.user_id ? "order-1 items-end" : "order-2"}`}
        >
          <div>
            <div
              className={`${
                // !["text", "video", "audio"].includes(
                //   messageData.message_type!,
                // )
                //   ? ""
                //   :
                // messageData.User?.user_id == userData?.user_id
                //   ? "primary-gradient rounded-br-none"
                //   : "rounded-bl-none bg-otherMessageBg"
                messageData.User?.user_id == userData?.user_id
                  ? `${isOnlyEmojis(messageData.message_content) && messageData.message_type === "text" ? "text-right" : "primary-gradient rounded-br-none"} ml-auto`
                  : `${isOnlyEmojis(messageData.message_content) && messageData.message_type === "text" ? "" : "rounded-bl-none  bg-otherMessageBg"}`
                } group relative flex w-fit min-w-[1rem] ${location.pathname !== "/video-call" ? "max-w-[17rem] sm:max-w-xl 2xl:max-w-3xl" : "max-w-[17rem] sm:max-w-xl lg:max-w-[17rem]"} flex-col  rounded-lg px-2  py-1 text-sm`}
            >
              {messageData.ParentMessage != null && (
                <ShowReplyMessage
                  reply_to={messageData.reply_to}
                  messageData={messageData.ParentMessage}
                />
              )}
              {currentConversationData.chat_type == "group" &&
                messageData.User?.user_id != userData?.user_id && (
                  <div
                    style={{
                      color: getRandomColor(messageData.User.user_name, theme),
                    }}
                    className={`pb-1 text-xs`}
                  >
                    <ShowSavedName
                      user_id={messageData.User.user_id.toString()}
                      name={messageData.User.full_name}
                    />
                  </div>
                )}
              <div className="flex h-full w-full">
                {
                  <>
                    {
                      messageData.deleted_for_everyone === true ? (
                        messageData.User.user_id == userData.user_id ? (
                          <div className="pr-5">
                            🚫 You deleted this message!
                          </div>
                        ) : (
                          <div className="pr-5">
                            🚫 This message was deleted!
                          </div>
                        )
                      ) : messageData.deleted_for.includes(userData.user_id) ? (
                        <div className="pr-5">🚫 You deleted this message!</div>
                      ) : messageData.message_type == "story_reply" ? (
                        <ShowStatusReply messageData={messageData} />
                      ) : messageData.message_type === "text" ? (
                        <div
                          className={` ${isOnlyEmojis(messageData.message_content) ? "text-4xl" : "pr-5"} `}
                          style={{ overflowWrap: "anywhere" }}
                        >
                          {messageData.message_content}
                        </div>
                      ) : messageData.message_type === "link" ? (
                        <div className="w-full">
                          <LinkPreview
                            right={messageData.User.user_id == userData.user_id}
                            url={messageData.message_content}
                          />
                        </div>
                      ) : messageData.message_type === "image" ? (
                        <div
                          onClick={() => {
                            handleImageClick(imageIndex);
                          }}
                        >
                          <LoadingSkeletonImageDynamic
                            radius=""
                            className={` ${messageData.User?.user_id == userData.user_id
                              ? "rounded-br-none"
                              : "rounded-bl-none"
                              } min-h-44 min-w-60 cursor-pointer select-none rounded-lg object-cover transition-all duration-300 ${location.pathname != "/video-call" ? "lg:h-56 lg:w-96" : "lg:h-40 "} `}
                            image_height=""
                            image_url={messageData.message_content}
                            image_width=""
                          />
                        </div>
                      ) : messageData.message_type === "gif" ? (
                        <div
                          onClick={() => {
                            handleImageClick(imageIndex);
                          }}
                        >
                          <LoadingSkeletonImageDynamic
                            radius=""
                            className={` ${messageData.User?.user_id == userData.user_id
                              ? "rounded-br-none"
                              : "rounded-bl-none"
                              } min-h-40 min-w-60 cursor-pointer select-none rounded-lg object-cover transition-all duration-300 ${location.pathname != "/video-call" ? "lg:h-56 lg:w-96" : "lg:h-40"}`}
                            image_height=""
                            image_url={messageData.message_content}
                            image_width=""
                          />
                        </div>
                      ) : messageData.message_type === "video" ? (
                        <div
                          onClick={() => {
                            handleImageClick(imageIndex);
                          }}
                          className={` ${messageData.User?.user_id == userData.user_id
                            ? "rounded-br-none"
                            : "rounded-bl-none"
                            } relative h-44 w-60 cursor-pointer overflow-hidden rounded-lg ${location.pathname != "/video-call" ? "lg:h-56 lg:w-96" : "lg:h-40 lg:w-72"}`}
                        >
                          <div className="absolute grid h-full w-full place-content-center">
                            <FaPlay className="h-11 w-11 rounded-full bg-[#0000008F] p-3 text-white" />
                          </div>
                          <LoadingSkeletonImageDynamic
                            radius=""
                            className={`h-44 select-none object-cover ${location.pathname != "/video-call" ? "lg:h-56 lg:w-96" : "lg:h-40"}`}
                            image_height="100%"
                            image_url={messageData.message_thumbnail}
                            image_width="100%"
                          />
                        </div>
                      ) : messageData.message_type === "doc" ? (
                        <div
                          className={`w-full max-w-80 rounded-[9px] ${messageData.User?.user_id == userData.user_id ? "primary-gradient rounded-br-none" : "rounded-bl-none bg-pdfBg"} px-1 pb-3 pt-1 ${location.pathname != "/video-call" ? "lg:min-w-80" : "lg:min-w-44"} `}
                        >
                          <a
                            href={messageData.message_content}
                            target="_blank"
                            className={`flex items-center justify-between gap-2 rounded-[7px] p-4 px-6 text-sm ${theme == "dark" ? "bg-[#1D1D1D]" : "bg-[#FAFAFA]"}`}
                          >
                            <div className="flex items-center gap-2">
                              <img
                                className="h-10 w-10 object-cover"
                                src="/DarkIcons/pdf_icons.png"
                                alt=""
                              />
                              <div
                                className={`w-full ${theme == "dark" ? "text-white" : "text-black"} line-clamp-2 max-w-56 overflow-hidden`}
                              >
                                {messageData?.message_content
                                  ?.split("/")
                                  .pop()
                                  ?.split("-")
                                  .slice(1)
                                  .join("-") || ""}
                              </div>
                            </div>
                            <img
                              src="/DarkIcons/Download_icon.png"
                              className="h-8 w-8 cursor-pointer"
                              alt=""
                            />
                          </a>
                        </div>
                      ) : messageData.message_type === "audio" ? (
                        // <audio controls>
                        //   <source src={messageData.url} type="audio/ogg" />
                        //   <source src={messageData.url} type="audio/mpeg" />
                        //   Your browser does not support the audio element.
                        // </audio>
                        <AudioPlayer
                          src={messageData.message_content}
                          minimal={true}
                          width={350}
                          trackHeight={50}
                          barWidth={3}
                          gap={1}
                          visualise={true}
                          backgroundColor={
                            messageData.User?.user_id == userData.user_id
                              ? theme == "dark"
                                ? "#FFEDAB"
                                : "#FFEDAB"
                              : theme == "dark"
                                ? "#787878"
                                : "#DDDDDD"
                          }
                          barColor="#CCCCCC"
                          barPlayedColor="#000"
                          skipDuration={2}
                          seekBarColor="black"
                          // volumeControlColor="blue"
                          hideSeekBar={true}
                          hideTrackKnobWhenPlaying={true}
                        />
                      ) : messageData.message_type === "location" ? (
                        <div
                          className={`h-52 w-full max-w-80 rounded-[9px] ${messageData.User?.user_id == userData.user_id ? "primary-gradient rounded-br-none" : "rounded-bl-none bg-pdfBg"} min-w-64 pt-1 ${location.pathname != "/video-call" ? "sm:min-w-80" : "sm:min-w-72"}`}
                        >
                          <div className="mx-auto mt-1 h-40 w-[98%] max-w-80">
                            <GoogleMapReact
                              bootstrapURLKeys={{
                                key: import.meta.env.VITE_Google_MAP_KEY,
                              }}
                              defaultCenter={{
                                lat: Number(
                                  messageData.message_content?.split(",")[0],
                                ),
                                lng: Number(
                                  messageData.message_content?.split(",")[1],
                                ),
                              }}
                              defaultZoom={13}
                              draggable={false}
                            >
                              <MdLocationPin className="text-3xl text-black" />
                            </GoogleMapReact>
                          </div>
                          <div className="grid place-content-center">
                            <a
                              target="_blank"
                              href={`http://maps.google.com/maps?z=12&t=m&q=loc:${messageData.message_content?.split(",")[0]}+${messageData.message_content?.split(",")[1]}`}
                              className="mt-3 w-full cursor-pointer font-medium"
                            >
                              View Location
                            </a>
                          </div>
                        </div>
                      ) : messageData.message_type === "call" ? (
                        <CallInMessageList messageData={messageData} />
                      ) : (
                        messageData.message_type
                      )
                      // ) : messageData.message_type === "contact" ? (
                      //   <SharedContact messageData={messageData} />
                      // ) : messageData.message_type === "poll" ? (
                      //   <PollMessages messageData={messageData} />
                      // ) :
                      // messageData.message_type
                    }

                    {/* Hide options for call message and other messages */}
                    {messageData.message_type == "call" ||
                      messageData.deleted_for_everyone ||
                      messageData.deleted_for.includes(userData.user_id) ? (
                      ""
                    ) : (
                      <>

                        <div
                          className={`absolute ${messageData.message_type == "text" ? "right-0 top-1" : "right-3 top-3"} pl-2 opacity-0 ${MessageOptions.selectMessage ? "" : "group-hover:opacity-100"}`}
                        // className={`pl-2 opacity-0 ${["video", "image", "link", "location"].includes(messageData.message_type!) && "absolute right-3 top-3"} ${MessageOptions.selectMessage ? "" : "group-hover:opacity-100"}`}
                        >
                          <SelectedMessageOption messageData={messageData} />
                        </div>
                      </>
                    )}
                  </>
                }
              </div>
              {
                messageData.message_type == "call" ||
                  messageData.deleted_for_everyone ||
                  messageData.deleted_for.includes(userData.user_id) ? (
                  ""
                ) :
                  !MessageOptions.selectMessage && (
                    <div
                      onClick={() => {
                        dispatch(
                          updateMessageOptions({
                            selectMessage: true,
                            forward_message: true,
                          }),
                        );
                        dispatch(addMessage(messageData));
                      }} className={`absolute ${messageData.User?.user_id == userData?.user_id ? "-left-10 top-0" : "-right-10 top-0"} invisible group-hover/forward:visible  cursor-pointer flex items-center h-full `}>
                      <div className="bg-secondary rounded-full text-themeColor  p-1">
                        <RiArrowGoForwardLine className="text-lg" />
                      </div>
                    </div>
                  )}
            </div>

            <div
              className={`flex ${messageData.User?.user_id == userData?.user_id ? "flex-row-reverse" : ""} mt-2 items-center gap-x-2`}
            >
              <div className="text-xs text-lightText">
                {formatTimeOnly(messageData.createdAt)}
              </div>
              {messageData.User?.user_id == userData?.user_id && (
                <LiaCheckDoubleSolid
                  title={
                    messageData.message_seen_status == "seen"
                      ? "Seen"
                      : "Unseen"
                  }
                  className={`h-5 w-5 ${messageData.message_seen_status == "seen"
                    ? "text-[#54E0FF]"
                    : "text-gray-400"
                    } `}
                />
              )}
              {messageData.starred && (

                <div
                  className="theme-colored-icon h-3 w-3"
                  style={{
                    maskImage: `url('/Home/Star - Iconly Pro.png')`,
                    WebkitMaskImage: `url('/Home/Star - Iconly Pro.png')`,
                  }}
                />
              )}
              {messageData.pinned && (
                <>
                  {/* <img
                    className="h-4 w-4 object-contain "
                    src={theme == "dark" ? PinDarkIcon : PinIcon}
                    alt=""
                  /> */}
                  <div
                    className="theme-colored-icon h-4 w-4"
                    style={{
                      maskImage: `url('${theme == "dark" ? PinDarkIcon : PinIcon}')`,
                      WebkitMaskImage: `url('${theme == "dark" ? PinDarkIcon : PinIcon}')`,
                    }}
                  />
                </>
              )}
            </div>
          </div>
        </div>

        <img
          src={
            messageData.User?.user_id == userData?.user_id
              ? messageData.User?.profile_pic
              : messageData.User?.profile_pic
          }
          alt="My profile"
          className={`h-7 w-7 rounded-full object-cover ${messageData.User?.user_id == userData?.user_id
            ? "order-2"
            : "order-1"
            } mt-auto ${["video", "image"].includes(messageData.message_type!)
              ? "mb-7"
              : "mb-5"
            }`}
        />
      </div>
    </div>
  );
};

export default MyMessage;
