import LoadingSkeletonImageDynamic from "../../../../components/LoadingSkeletonImageDynamic";
import { useAppDispatch, useAppSelector } from "../../../../utils/hooks";
import { updateForwardedUserId } from "../../../../store/Slices/ForwardMessageSlice";
import { IoIosCheckmarkCircle } from "react-icons/io";
import { GiCircle } from "react-icons/gi";
import { useBlockUserList } from "../../../../store/api/useBlockUserList";

export default function ForwardMessageToContactList({
  searchUser,
}: {
  searchUser: string;
  handleCloseModal: () => void;
}) {
  const ForwardMessageData = useAppSelector((state) => state.ForwardMessage);
  const ContactList = useAppSelector((state) => state.ContactList);
  const { data: blockList } = useBlockUserList();
  const OnlineUserList = useAppSelector((state) => state.OnlineUserList);
  const dispatch = useAppDispatch();
  const userData = useAppSelector((state) => state.userData);

  return (
    <div className="flex h-[60vh] w-full max-w-full flex-col overflow-y-auto overflow-x-hidden pb-10">
      {ContactList?.data
        ?.filter((contact) => {
          // Exclude blocked contacts
          if (blockList?.data.Records.find((e) => e.user_id == contact.user_id))
            return false;
          // Exclude yourself
          if (contact.user_id == userData.user_id) {
            return false;
          }

          // Apply search filter
          return (
            contact.name.toLowerCase().includes(searchUser.toLowerCase()) ||
            contact.name.toLowerCase().includes(searchUser.toLowerCase())
          );
        })
        .map((e) => {
          return (
            <>
              <div
                onClick={() => {
                  dispatch(
                    updateForwardedUserId({
                      user_id: e.user_id,
                    }),
                  );
                  // forwardMessage({ chat_id: e.Records[0].chat_id });
                }}
                className={`flex cursor-pointer items-center justify-start px-3 py-4 hover:bg-selectedChat`}
              >
                <div className="relative mr-3">
                  <LoadingSkeletonImageDynamic
                    radius=""
                    className="min-h-10 min-w-10 rounded-full object-cover 2xl:min-h-12 2xl:min-w-12"
                    image_height="100%"
                    image_url={e?.profile_pic}
                    image_width=""
                  />
                  {OnlineUserList.onlineUsers.find(
                    (user) => user.user_id == e?.user_id,
                  ) && (
                    <img
                      className="absolute bottom-0 right-0 z-30 h-4 w-4"
                      src="/Home/Online_Green_dot.png"
                      alt=""
                    />
                  )}
                </div>

                <div>
                  <div className="max-w-40 truncate text-base font-medium capitalize text-darkText">
                    {e.name}
                  </div>

                  {/* <div className="flex items-center gap-x-1">
                    <div className="line-clamp-1 flex w-full max-w-[12.5rem] gap-x-1 text-[13px] text-lightText">
                      {e.is_group ? e.group_name : e.user_name}
                    </div>
                  </div> */}
                </div>

                <button className={`relative ml-auto overflow-hidden`}>
                  {ForwardMessageData.forwarded_user_id.includes(e.user_id) ? (
                    <IoIosCheckmarkCircle className="h-6 w-6 text-themeColor" />
                  ) : (
                    <GiCircle className="h-6 w-6 " />
                  )}
                </button>
              </div>
              <hr className="border-t border-borderColor" />
            </>
          );
        })}
    </div>
  );
}
