import { RxCross2 } from "react-icons/rx";
import { useAppDispatch, useAppSelector } from "../../../../utils/hooks";
import { updateMessageOptions } from "../../../../store/Slices/MessageOptionsSlice";
import TextTranslate from "../../../../utils/TextTranslate";

export default function ForwardSelectedMessage() {
  const MessageOptions = useAppSelector((state) => state.MessageOptions);
  const dispatch = useAppDispatch();
  if (!MessageOptions?.message_list?.Records?.length) return;

  return (
    // <div className="absolute flex w-full items-center justify-center bg-primary">
    //   <div className="flex w-[90%] items-center justify-between gap-3">
    <div className="relative z-50 -mt-16 flex h-20 w-full items-center justify-between bg-messageHead px-10 pb-[1.3rem] lg:mt-0 xl:px-20">
      <div className="flex items-center gap-3">
        <RxCross2
          onClick={() => {
            dispatch(
              updateMessageOptions({
                message_list: {
                  Records: [],
                  Pagination: {
                    total_pages: 0,
                    total_records: 0,
                    current_page: 0,
                    records_per_page: 0,
                  },
                },
                forward_message: false,
                selectMessage: false,
              }),
            );
          }}
          className="cursor-pointer text-xl"
        />
        <div>{MessageOptions.message_list?.Records.length} messages</div>
      </div>
      <button
        onClick={() => {
          dispatch(
            updateMessageOptions({
              show_forward_message_modal: true,
            }),
          );
        }}
        className={
          "relative min-h-10 w-fit overflow-hidden rounded-lg px-4 text-base primary-gradient outline-none lg:px-9 lg:text-lg"
        }
      >
        <TextTranslate text="Forward To" />
      </button>
    </div>
  );
}
