import React from "react";
import { useAppSelector } from "../../../../utils/hooks";

export default function IfUserBlocked() {
  const currentConversationData = useAppSelector(
    (state) => state.CurrentConversation,
  );

  return (
    <div className="lg:mt-0 -mt-16">
      {currentConversationData.is_group_blocked && (
        <div className="grid h-14 w-full place-content-center bg-messageHead">
          <div>You Blocked {currentConversationData.full_name} </div>
        </div>
      )}
      {currentConversationData.other_user_blocked_you && (
        <div className="grid h-14 w-full place-content-center bg-messageHead">
          <div>You Blocked by {currentConversationData.full_name}</div>
        </div>
      )}
    </div>
  );
}
