import { VscSend } from "react-icons/vsc";
import { useTheme } from "../../../../context/ThemeProvider";
import { updateSendMessageData } from "../../../../store/Slices/SendMessageSlice";
import { useAppDispatch, useAppSelector } from "../../../../utils/hooks";
import EmojiPickerCompo from "./EmojiPickerCompo";
import useApiPost from "../../../../hooks/PostData";
import { Message, MessageList } from "../../../../types/MessageListType";
import { appendMessageWithDateCheck } from "../../../../store/Slices/MessageListSlice";
import SelectFile from "./SelectFile";
import ShowSelectedFile from "./ShowSelectedFile";
import { useFile } from "../../../../context/FileProvider";
import { ClipLoader } from "react-spinners";
import base64ToFile from "../../../../utils/base64ToFile";
import { socketInstance } from "../../../../socket/socket";
import SelectedReplyMessage from "../ReplyMessage/SelectedReplyMessage";
import { useScrollToBottom } from "react-scroll-to-bottom";
import { useEffect, useRef, useState } from "react";
import { updateViewState } from "../../../../store/Slices/ViewManagerSlice";
import toast from "react-hot-toast";
import { updateCurrentConversation } from "../../../../store/Slices/CurrentConversationSlice";
import { useTranslateText } from "../../../../hooks/useTranslateText";
import { useLocation } from "react-router-dom";
import { isLink } from "../../../../utils/isLink";
import { useConversationMedia } from "../../../../store/api/useConversationMedia";
import { useConversationDocuments } from "../../../../store/api/useConversationDocuments";
import { useConversationLinks } from "../../../../store/api/useConversationLinks";

export default function SendMessage() {
  // @ts-ignore
  const { theme } = useTheme();
  const messageData = useAppSelector((state) => state.SendMessageData);
  const currentConversationData = useAppSelector(
    (state) => state.CurrentConversation,
  );
  const { refetch: refetchConversationMedia } = useConversationMedia();
  const { refetch: refetchConversationDocuments } = useConversationDocuments();
  const { refetch: refetchConversationLinks } = useConversationLinks();
  const previouse_conversation_id = currentConversationData.chat_id;
  const [isStoppedTyping, setIsStoppedTyping] = useState(true);
  const typingTimeoutRef = useRef<NodeJS.Timeout | null>(null); // ✅ holds timeout across renders
  const [isKeyboardOpen, setIsKeyboardOpen] = useState(false);
  const [isIOS, setIsIOS] = useState(false);

  const { selectedFile, setSelectedFile } = useFile();
  // let { refetch } = useConversationInfo();

  const dispatch = useAppDispatch();
  const { loading: sendMessageLoading, progress, postData } = useApiPost();
  const scrollToBottom = useScrollToBottom();
  const translate = useTranslateText();
  const location = useLocation();

  const keydownListenerRef = useRef<(e: KeyboardEvent) => void>(); // Ref for event listener
  const inputRef = useRef<HTMLTextAreaElement>(null);

  useEffect(() => {
    // Function to check if screen is large (Tailwind 'lg': 1024px and above)
    const isLargeScreen = window.innerWidth >= 1024;

    if (isLargeScreen && inputRef.current) {
      inputRef.current.focus();
    }
    // else if (messageData.reply_to) {
    //   inputRef.current?.focus();
    // }
  }, [currentConversationData.chat_id, messageData.reply_to]);

  // To send message on enter key press Starts ===================================================================
  useEffect(() => {
    // Function to handle key down
    const handleKeyDown = (e: KeyboardEvent) => {
      if (e.key === "Enter" && !e.shiftKey) {
        e.preventDefault(); // Prevents newline
        if (selectedFile || messageData.message?.trim() !== "") {
          sendMessageApiCall(e);
        }
      }
    };

    // Assign the handler to the ref
    keydownListenerRef.current = handleKeyDown;
  }, [selectedFile, messageData]); // Update whenever selectedFile changes

  useEffect(() => {
    setIsIOS(/iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream);
  }, []);

  useEffect(() => {
    const listener = (e: KeyboardEvent) => {
      if (keydownListenerRef.current) {
        keydownListenerRef.current(e); // Call the current handler in the ref
      }
    };

    window.addEventListener("keydown", listener);

    return () => {
      window.removeEventListener("keydown", listener);
    };
  }, []);
  // To send message on enter key press Ends ===================================================================

  // useEffect(() => {
  //   const handleKeyDown = (e: KeyboardEvent) => {
  //     if (e.key === "Enter") {
  //       e.preventDefault(); // Prevent default behavior
  //       // alert("enter key press");
  //       if (selectedFile) {
  //         sendMessageApiCall(e);
  //       }
  //     }
  //   };

  //   // Attach the event listener
  //   window.addEventListener("keydown", handleKeyDown);

  //   // Cleanup the event listener when the component unmounts
  //   return () => {
  //     window.removeEventListener("keydown", handleKeyDown);
  //   };
  // }, []);

  async function sendMessageApiCall(e: any) {
    e.preventDefault();
    // If message is sending then new message can not be send ===================================================
    if (sendMessageLoading) {
      return;
    }
    const messageFormData = new FormData();

    // Ensure chat_id is present, otherwise return early
    if (
      !currentConversationData.chat_id &&
      currentConversationData.user_id == 0
    ) {
      return;
    }
    // Ensure message_type is present, otherwise return early
    if (!messageData.message_type) {
      return;
    }
    if (
      currentConversationData.chat_id != -1 &&
      currentConversationData.chat_id != 0
    ) {
      // Append chat_id
      messageFormData.append(
        "chat_id",
        currentConversationData.chat_id.toString(),
      );
      // messageFormData.append(
      //   "user_id",
      //   String(currentConversationData.user_id),
      // );
    } else {
      messageFormData.append(
        "user_id",
        String(currentConversationData.user_id),
      );
    }
    // Append message_type
    messageFormData.append("message_type", messageData.message_type!);

    // Append message type and the corresponding data based on message_type
    switch (messageData.message_type) {
      case "text": {
        if (messageData.message) {
          if (isLink(messageData.message)) {
            messageFormData.delete("message_type");
            messageFormData.append("message_type", "link");
            messageFormData.append("message_content", messageData.message);
          } else {
            messageFormData.append("message_content", messageData.message);
          }
        }
        break;
      }
      case "image": {
        messageFormData.append("files", selectedFile!);
        messageFormData.append("message_content", "");

        break;
      }
      case "gif": {
        messageFormData.append("message_content", messageData.message!);
        break;
      }
      case "video": {
        if (messageData.thumbnail_url != "" && messageData.thumbnail_url) {
          const thumbnailBlob = base64ToFile(
            messageData.thumbnail_url,
            "image/png",
            "thumbnail.png",
          );
          messageFormData.append("files", thumbnailBlob);
          messageFormData.append("files", selectedFile!);
          messageFormData.append("message_content", "");
        } else {
          console.log("return");
          return;
        }
        break;
      }
      case "doc":
        messageFormData.append("files", selectedFile!);
        messageFormData.append("message_content", "");
        break;

      default:
        // Handle unknown message_type or cases that don't need extra fields
        messageFormData.append("message_type", messageData.message_type!);
        messageFormData.append("message_content", "");
        break;
    }

    // Append other optional fields that might be relevant regardless of type
    if (messageData.forward_id) {
      messageFormData.append("forward_id", messageData.forward_id.toString());
    }

    if (messageData.reply_to) {
      messageFormData.append("reply_to", messageData.reply_to.toString());
    }

    if (messageData.status_id) {
      messageFormData.append("story_id", messageData.status_id.toString());
      messageFormData.delete("message_type");
      messageFormData.append("message_type", "story_reply");
    }

    // Make the API call with the constructed FormData
    const { data: sendMessageRes }: { data: Message } = await postData(
      "chat/send-message",
      messageFormData,
      "multipart/form-data",
    );

    // Handle the response (if needed)
    if (sendMessageRes) {
      console.log(sendMessageRes, "sendMessageRes");

      // Refetch the media in sidebar ===============================================================
      if (
        sendMessageRes.message_type == "image" ||
        sendMessageRes.message_type == "video"
      ) {
        refetchConversationMedia();
      }
      if (sendMessageRes.message_type == "doc") {
        refetchConversationDocuments();
      }
      if (sendMessageRes.message_type == "link") {
        refetchConversationLinks();
      }
      socketInstance().emit("typing", {
        chat_id: currentConversationData.chat_id,
        typing: false,
      });
      setIsStoppedTyping(true);
      // @ts-ignore
      if (sendMessageRes.is_block) {
        toast.error(`${currentConversationData.user_name} Blocked You! `);
        return;
      }

      scrollToBottom();
      // append new message to message list

      if (
        currentConversationData.chat_id == 0 ||
        currentConversationData.chat_id == -1
      ) {
        dispatch(
          updateCurrentConversation({
            chat_id: sendMessageRes.chat_id,
          }),
        );
      }

      // if (sendMessageRes.chat_id == currentConversationData.chat_id) {
      //   dispatch(appendMessageWithDateCheck(sendMessageRes));
      // }
      // Remove Value from input box
      dispatch(
        updateSendMessageData({
          message: "",
          message_type: "",
          reply_to: 0,
        }),
      );

      // Remove selected files
      setSelectedFile(null);

      // console.log(sendMessageRes.message_id, sendMessageRes.message_id);
      // setTimeout(() => {
      //   scrollToMessage(sendMessageRes.message_id, false, true);
      // }, 1000);

      // refetch();
      // Update Chat list
      // socketInstance().emit("ChatList", {});
      // Reset textarea height after sending
      if (inputRef.current) {
        inputRef.current.style.height = "auto";
      }
    } else {
      // Error handling here
    }
  }

  async function sendTypingStatus() {
    // Emit typing status only if typing had stopped before
    if (isStoppedTyping) {
      socketInstance().emit("typing", {
        chat_id: currentConversationData.chat_id,
        typing: true,
      });
      setIsStoppedTyping(false); // Mark typing has started
    }

    // Clear existing timeout to reset inactivity timer
    if (typingTimeoutRef.current) {
      clearTimeout(typingTimeoutRef.current);
    }

    // Set a new timeout to emit "typing: false" after 3 seconds of no typing
    typingTimeoutRef.current = setTimeout(() => {
      socketInstance().emit("typing", {
        chat_id: currentConversationData.chat_id,
        typing: false,
      });
      setIsStoppedTyping(true); // Mark typing has stopped
    }, 3000);
  }

  return (
    <div
      // className={` ${location.pathname != "/video-call" && "absolute"} flex w-full -translate-y-12 items-center justify-center transition-all duration-300 md:translate-y-0`}
      className={`absolute -bottom-16 flex w-full lg:-bottom-3 ${isIOS ? (isKeyboardOpen ? "-translate-y-20" : "-translate-y-20") : isKeyboardOpen ? "-translate-y-14" : "-translate-y-14"} items-center justify-center bg-primary pb-8 pt-2 transition-all duration-300 sm:bg-transparent sm:pt-0 md:translate-y-0`}
    >
      <div className="flex w-[90%] items-center gap-3 xl:w-[90%]">
        <div
          className={`relative flex h-fit max-h-40 w-full gap-2 rounded-xl ${selectedFile == null && "border"} bg-secondary ${theme == "dark" ? "border-[#EEEEEE14]" : "border-[#B0B0B0]"} `}
        >
          <EmojiPickerCompo />
          <ShowSelectedFile
            progress={progress}
            sendMessageLoading={sendMessageLoading}
          />
          <SelectedReplyMessage />
          {/* <form
            className="w-full"
            // onSubmit={sendMessageApiCall}
          >
            <input
              ref={inputRef}
              value={messageData.message_type == "gif" ? "" : messageData.message}
              onChange={(e) => {
                sendTypingStatus();
                if (sendMessageLoading) {
                  return;
                }
                dispatch(
                  updateSendMessageData({
                    chat_id: currentConversationData.chat_id,
                    message: e.target.value,
                    message_type: "text",
                  }),
                );
              }}
              onFocus={() => {
                dispatch(
                  updateViewState({
                    showOtherProfile: false,
                    showSearchMessage: false,
                    showStarMessageList: false,
                    showMediaDocLinks: false,
                  }),
                );
              }}
              type="text"
              className="h-full w-full bg-transparent px-2 text-sm placeholder-lightText outline-none"
              placeholder={translate("Type Message")}
            />
          </form> */}

          <form
            className="w-full"
          // onSubmit={sendMessageApiCall}
          >
            <textarea
              ref={inputRef}
              value={
                ["location", "gif"].includes(messageData.message_type!)
                  ? ""
                  : messageData.message
              }
              onChange={(e) => {
                const textarea = e.target;

                // Auto-resize logic
                textarea.style.height = "auto";
                textarea.style.height = `${textarea.scrollHeight}px`;

                sendTypingStatus();
                if (sendMessageLoading) {
                  return;
                }

                const value = textarea.value;

                if (value.trim() === "") {
                  textarea.style.height = "auto"; // Reset to default if cleared
                }

                dispatch(
                  updateSendMessageData({
                    chat_id: currentConversationData.chat_id,
                    message: value,
                    message_type: "text",
                  }),
                );
              }}
              onFocus={() => {
                setIsKeyboardOpen(true);
                dispatch(
                  updateViewState({
                    showOtherProfile: false,
                    showSearchMessage: false,
                    showStarMessageList: false,
                    showMediaDocLinks: false,
                  }),
                );
              }}
              onBlur={() => {
                setIsKeyboardOpen(false);
              }}
              className="h-full w-full resize-none bg-transparent px-2 py-2  text-sm placeholder-lightText outline-none"
              placeholder={translate("Type Message")}
              rows={1} // Start with single line
              style={{
                maxHeight: "9rem", // Set max height before scrolling
                overflowY: "auto",
              }}
            />
          </form>
          <SelectFile />
        </div>
        <div
          onClick={(e) => {
            if (messageData.message_type == "video") {
              if (
                messageData.thumbnail_url == "" ||
                !messageData.thumbnail_url
              ) {
                return;
              }
            }
            sendMessageApiCall(e);
          }}
          className="primary-gradient grid h-11 min-w-12 cursor-pointer place-content-center rounded-xl"
        >
          {messageData.chat_id == currentConversationData.chat_id &&
            sendMessageLoading ? (
            <ClipLoader size={25} className="" />
          ) : (
            <VscSend className="-rotate-45 text-xl" />
          )}
        </div>
      </div>
    </div>
  );
}
