import React from "react";
import { Message, MessageUser } from "../../../types/MessageListType";
import { useAppSelector } from "../../../utils/hooks";

export default function SystemMessage({
  messageData,
}: {
  messageData: Message;
}) {
  const ContactList = useAppSelector((state) => state.ContactList);
  const userData = useAppSelector((state) => state.userData);

  function returnSavedName(MessageUser: MessageUser) {
    if (MessageUser?.user_id == userData.user_id) {
      return "You";
    }
    const user = ContactList?.data?.find(
      (e) => e?.user_id == MessageUser?.user_id,
    );
    return user?.name ?? MessageUser?.full_name;
  }

  return (
    <div
      key={messageData.message_id}
      id={String(messageData.message_id)}
      className="mx-auto my-3 w-fit rounded-full bg-primary px-5 py-1 text-center text-sm font-medium capitalize text-darkText shadow-sm"
    >
      {messageData.message_type == "member-added"
        ? `${returnSavedName(messageData.User!)} added ${returnSavedName(messageData.ActionedUser!)} to group`
        : messageData.message_type == "member-removed"
          ? `${returnSavedName(messageData.User!)} removed ${returnSavedName(messageData.ActionedUser!)} from group`
          : messageData.message_type == "member-left"
            ? `${returnSavedName(messageData.User!)} left group`
            : messageData.message_type == "promoted-as-admin"
              ? `${returnSavedName(messageData.ActionedUser!)} ${messageData.ActionedUser?.user_id == userData.user_id ? "are" : "is"} now group admin`
              : messageData.message_type == "removed-as-admin"
                ? `${returnSavedName(messageData.ActionedUser!)} is removed from group admin`
                : messageData.message_type == "group-created"
                  ? `${returnSavedName(messageData.User!)} created group`
                  : messageData.message_content}
    </div>
  );
}
