/* eslint-disable @typescript-eslint/ban-ts-comment */
import { ClipLoader } from "react-spinners";
import { useTheme } from "../../../context/ThemeProvider";
import { useState } from "react";
import SearchNotFoundAnimation from "../../../components/SearchNotFoundAnimation";
import { useNotificationList } from "../../../store/api/useNotificationList";
import { IoNotificationsOutline } from "react-icons/io5";
import chatSidebarTime from "../../../utils/chatSidebarTime";

export default function NotificationList() {
  const [selectedReportId, setSelectedReportId] = useState(0);
  // @ts-ignore
  const { theme } = useTheme();
  const { data, isLoading } = useNotificationList();



  return (
    <div className="pb-14 flex h-[60vh] w-full max-w-full flex-col overflow-y-auto overflow-x-hidden">
      {isLoading ? (
        <div className="grid h-full place-content-center">
          <ClipLoader size={23} color={theme == "dark" ? "white" : "black"} />
        </div>
      ) : data?.data?.Records?.length == 0 ? (
        <div className="grid h-96 place-content-center gap-5">
          <SearchNotFoundAnimation />
          <div>No Notifications </div>
        </div>
      ) : (
        data?.data?.Records?.map((e) => {
          return (
            <>
              <div
                onClick={() => {
                  setSelectedReportId(e.notification_id);
                }}
                className={`hover:bg-selectedChatdata flex cursor-pointer items-center justify-start px-3 py-4`}
              >
                <div className="flex items-center gap-3 w-full">
                  <div className="rounded-full bg-themeColor grid h-9 w-9 place-content-center">
                    <div><IoNotificationsOutline className="text-lg" /></div>
                  </div>
                  <div className="flex flex-col">
                    <div className="text-sm text-darkText font-medium capitalize">
                      {e?.title} Users
                    </div>
                    <div className="text-sm font-medium capitalize text-darkText opacity-50">
                      {e?.message} from whoxa
                    </div>
                  </div>
                  <div className="ml-auto mr-0 text-sm">{chatSidebarTime(e?.createdAt)}</div>
                </div>
              </div>
              <hr className="border-t border-borderColor" />
            </>
          );
        })
      )}

    </div>
  );
}
