import React from "react";
import { Dialog, DialogPanel, DialogTitle } from "@headlessui/react";
import { RxCross2 } from "react-icons/rx";
import { useAppDispatch, useAppSelector } from "../../../utils/hooks";
import NotificationList from "./NotificationList";
import { updateViewState } from "../../../store/Slices/ViewManagerSlice";

const NotificationModal: React.FC = () => {
  const dispatch = useAppDispatch();
  const handleCloseModal = () => {
    dispatch(
      updateViewState({
        show_notification_modal: false,
      })
    );
  };

  const ViewManager = useAppSelector((state) => state.ViewManager);
  return (
    <Dialog
      open={ViewManager.show_notification_modal}
      onClose={handleCloseModal}
      className="relative z-50"
    >
      <div className="fixed inset-0 bg-black/35 backdrop-blur-sm">
        <div className="flex min-h-full items-center justify-center p-4">
          <DialogPanel className="relative max-h-[80vh] w-full max-w-sm overflow-hidden rounded-xl bg-primary transition-transform duration-300 ease-out">
            <DialogTitle
              as="h3"
              style={{
                backgroundSize: "100%",
              }}
              className="w-full space-y-5 primary-gradient bg-no-repeat px-4 xl:space-y-7"
            >
              <div className="flex items-center gap-3 py-7 font-semibold ">
                <RxCross2
                  onClick={handleCloseModal}
                  className="cursor-pointer text-2xl"
                />
                <span className="">Notification</span>
              </div>
            </DialogTitle>
            <NotificationList />
          </DialogPanel>
        </div>
      </div>
    </Dialog>
  );
};

export default NotificationModal;
