import { FaCheckCircle } from "react-icons/fa";
import { useAvtarList } from "../../../store/api/useAvtarList";
import { updateSpesificUserData } from "../../../store/Slices/UserSlice";
import { useAppDispatch, useAppSelector } from "../../../utils/hooks";
import { ClipLoader } from "react-spinners";
import { useTheme } from "../../../context/ThemeProvider";
import TextTranslate from "../../../utils/TextTranslate";
import { useEffect } from "react";
import { useLocation } from "react-router-dom";

export default function SelectAvtar() {
  const { data: avtarData, isLoading } = useAvtarList();

  const dispatch = useAppDispatch();
  const userData = useAppSelector((state) => state.userData);

  // @ts-ignore
  const { theme } = useTheme();
  console.log(avtarData, "avtarData");
  const location = useLocation();

  useEffect(() => {
    if (
      avtarData?.data?.Records?.length > 0 &&
      location.pathname == "/select-profile"
    ) {
      dispatch(
        updateSpesificUserData({
          avatar_path: avtarData?.data?.Records[0].avatar_media,
        }),
      );
    }
  }, [avtarData?.data?.Records, location.pathname]);

  return (
    <>
      <div className="space-y-3 rounded-xl border border-borderColor p-4">
        <div className="font-medium">
          <TextTranslate text="Choose Avtar" />
        </div>
        <div className="avtar-containar flex gap-x-3 overflow-x-auto pb-3">
          {isLoading ? (
            <div className="grid h-28 w-full place-content-center">
              <ClipLoader
                size={23}
                color={theme == "dark" ? "white" : "black"}
              />
            </div>
          ) : (
            <>
              {avtarData?.data?.Records.map((avtar) => {
                return (
                  <>
                    <div
                      onClick={() => {
                        dispatch(
                          updateSpesificUserData({
                            avatar_path: avtar.avatar_media,
                          }),
                        );
                      }}
                      className={`relative h-28 w-28 shrink-0 cursor-pointer rounded-full ${userData.avatar_path == avtar.avatar_media && "border border-themeColor "} p-1`}
                    >
                      <img
                        className="h-full w-full rounded-full"
                        src={avtar.avatar_media}
                        alt=""
                      />
                      {userData.avatar_path == avtar.avatar_media && (
                        <label
                          htmlFor="groupPhotoEdit"
                          className="absolute bottom-0 right-0 z-30 grid h-7 w-7 cursor-pointer place-content-center rounded-full bg-white"
                        >
                          <FaCheckCircle className="text-xl text-themeColor" />
                        </label>
                      )}
                    </div>
                  </>
                );
              })}
            </>
          )}
        </div>
      </div>
    </>
  );
}
