import LoadingSkeletonImageDynamic from "../../../components/LoadingSkeletonImageDynamic";
import { useAppDispatch, useAppSelector } from "../../../utils/hooks";
import { ClipLoader } from "react-spinners";
import { useTheme } from "../../../context/ThemeProvider";
import { updateCurrentConversation } from "../../../store/Slices/CurrentConversationSlice";
import { removeMessageList } from "../../../store/Slices/MessageListSlice";
import { useConversationInfo } from "../../../store/api/useConversationInfo";
import { usePublicGroupList } from "../../../store/api/usePublicGroupList";
import { AllPublicGroup } from "../../../types/ResType";
import SearchNotFoundAnimation from "../../../components/SearchNotFoundAnimation";

export default function PublicGroupList({
  searchUser,
}: {
  searchUser: string;
}) {
  const { data: publicGroupList, isLoading } = usePublicGroupList({
    group_name: searchUser,
  });

  const dispatch = useAppDispatch();
  const currentConversationData = useAppSelector(
    (state) => state.CurrentConversation,
  );
  // @ts-ignore
  const { theme } = useTheme();
  const { refetch } = useConversationInfo();

  function changeCurrentConversation(group: AllPublicGroup) {
    if (group.chat_id == currentConversationData.chat_id) {
      return;
    }
    // let chat_id =
    //   ChatListArray.find(
    //     (chatUser) => chatUser.chat_id == group.chat_id,
    //   )?.chat_id ?? 0;

    // if (
    //   currentConversationData.chat_id == chat_id &&
    //   currentConversationData.chat_id != 0
    // ) {
    //   return;
    // }

    dispatch(
      updateCurrentConversation({
        chat_id: group.chat_id,
        chat_type: "public_group",
        group_name: group.group_name,
        group_icon: group.group_profile_image,
        last_message: "",
        last_message_type: "",
        user_id: 0,
        user_name: "",
        mobile_num: "",
        profile_image: "",
        is_block: false,
        createdAt: new Date(),
        updatedAt: new Date(),
        public_group: true,
      }),
    );
    dispatch(removeMessageList());
    refetch();
  }

  return (
    <div className="my-5 flex h-[60vh] w-full max-w-full flex-col overflow-y-auto overflow-x-hidden pb-20">
      {isLoading ? (
        <div className="grid h-full place-content-center">
          <ClipLoader size={23} color={theme == "dark" ? "white" : "black"} />
        </div>
      ) : publicGroupList?.allPublicGroup?.length == 0 ? (
        <div className="grid h-96 place-content-center gap-5">
          <SearchNotFoundAnimation />
          <div>No Public group found</div>
        </div>
      ) : (
        // publicGroupList?.myContactList
        //   // .filter(
        //   //   (contact) =>
        //   //     contact.full_name
        //   //       .toLowerCase()
        //   //       .includes(searchUser.toLowerCase()) &&
        //   //     userData.user_id != contact?.userDetails?.user_id,
        //   // )
        //   .filter(
        //     (contact) => userData.user_id != contact?.userDetails?.user_id,
        //   )
        //   .map((e) => {
        publicGroupList?.allPublicGroup
          .sort((a, b) => {
            const nameA = a?.group_name?.toLowerCase() || "";
            const nameB = b?.group_name?.toLowerCase() || "";
            return nameA.localeCompare(nameB);
          })
          .map((e) => {
            return (
              <>
                <div
                  onClick={() => {
                    changeCurrentConversation(e);
                    // if (location.pathname == "/contact-list") {
                    //   // changeCurrentConversation(e);
                    //   dispatch(
                    //     updateViewState({
                    //       show_chats_sidebar: false,
                    //     }),
                    //   );
                    //   return;
                    // }
                    //   if (
                    //     currentConversationData.chat_id != e.chat_id
                    //   ) {
                    //     dispatch(updateCurrentConversation(e));
                    //     dispatch(removeMessageList());
                    //   }
                  }}
                  onContextMenu={() => {
                    //   handleBlockContextMenu(e);
                    //   setSelectedConversation(e);
                  }}
                  //   key={e.id}
                  className={`flex cursor-pointer items-center px-3 py-4 hover:bg-selectedChat ${false && "bg-selectedChat"}`}
                >
                  <div className="relative mr-3 h-14 w-14 2xl:h-12 2xl:w-12">
                    <LoadingSkeletonImageDynamic
                      radius=""
                      className="min-h-12 min-w-12 rounded-full object-cover 2xl:h-12 2xl:w-12"
                      image_height="100%"
                      image_url={e?.group_profile_image}
                      image_width=""
                    />
                  </div>

                  <div>
                    <div className="text-base font-medium capitalize text-darkText">
                      {e?.group_name}
                    </div>
                  </div>
                </div>
                <hr className="border-t border-borderColor" />
              </>
            );
          })
      )}
    </div>
  );
}
