import React, { useEffect, useState } from "react";
import { Dialog, DialogPanel, DialogTitle } from "@headlessui/react";
import { RxCross2, RxRadiobutton } from "react-icons/rx";
import { useAppDispatch, useAppSelector } from "../../../utils/hooks";
import TextTranslate from "../../../utils/TextTranslate";
import { updateViewState } from "../../../store/Slices/ViewManagerSlice";
import Cookies from "js-cookie";
import { getContrastTextColor, themeColors } from "../../../utils/themeColors";
import { useWebsiteSettings } from "../../../store/api/useWebsiteSettings";

const SelectThemeColorModal: React.FC = () => {
  const dispatch = useAppDispatch();
  const ViewManager = useAppSelector((state) => state.ViewManager);
  const [color_id, setColorId] = useState(1);
  const { data: websiteSettings } = useWebsiteSettings()

  const handleCloseModal = () => {
    dispatch(
      updateViewState({
        show_select_theme_modal: false,
      })
    );
  };

  useEffect(() => {
    const tempColor_id = Cookies.get("color_id");
    setColorId(tempColor_id ? Number(tempColor_id) : 1);
  }, []);

  return (
    <Dialog
      open={ViewManager.show_select_theme_modal}
      onClose={() => { }}
      className="relative z-50"
    >
      <div className="fixed inset-0 bg-black/35 backdrop-blur-sm">
        <div className="flex min-h-full items-center justify-center p-4">
          <DialogPanel className="relative max-h-[80vh] w-full max-w-sm overflow-hidden rounded-xl bg-primary transition-transform duration-300 ease-out">
            <DialogTitle
              as="h3"
              style={{ backgroundSize: "100%" }}
              className="w-full space-y-5 primary-gradient bg-no-repeat px-4 xl:space-y-7"
            >
              <div className="flex items-center gap-3 py-7 font-semibold">
                <RxCross2
                  onClick={handleCloseModal}
                  className="cursor-pointer text-2xl"
                />
                <span>
                  <TextTranslate text="Theme Color" />
                </span>
              </div>
            </DialogTitle>

            <div className="relative mx-4 mt-2 h-fit pb-5">
              <div className="my-4 max-h-96 overflow-auto rounded-lg border border-borderColor p-3">
                <div className="grid grid-cols-4 justify-center gap-3">
                  {themeColors.map((color) => (
                    <div
                      key={color.id}
                      onClick={() => setColorId(color.id)}
                      className={`relative cursor-pointer rounded-full border-2 w-fit duration-300 transition-all ${color_id === color.id
                        ? "border-[var(--theme-color)] p-[3px] scale-90"
                        : "border-transparent p-[3px]"
                        }`}
                    >
                      <div
                        className="h-14 w-14 rounded-full"
                        style={{ backgroundColor: color.hex }}
                      ></div>
                    </div>

                  ))}
                </div>
              </div>

              <div className="flex justify-center gap-3">
                <button
                  onClick={() => {
                    const text_color = getContrastTextColor(websiteSettings?.data?.app_primary_color || "#FCC604");
                    Cookies.set("theme_color", websiteSettings?.data?.app_primary_color || "#FCC604");
                    Cookies.set("theme_text_color", text_color);
                    document.documentElement.style.setProperty("--theme-color", websiteSettings?.data?.app_primary_color || "#FCC604");
                    document.documentElement.style.setProperty("--theme-text-color", text_color);
                    handleCloseModal();
                    // location.reload();
                  }} className="border border-themeColor h-9 w-44 rounded-lg text-base font-medium">
                  Reset color
                </button>
                <button
                  onClick={() => {
                    const selectedColor = themeColors[color_id - 1];
                    Cookies.set("color_id", color_id.toString());
                    Cookies.set("theme_color", selectedColor.hex);
                    Cookies.set("theme_text_color", selectedColor.textColor);
                    document.documentElement.style.setProperty("--theme-color", selectedColor.hex);
                    document.documentElement.style.setProperty("--theme-text-color", selectedColor.textColor);
                    handleCloseModal();
                    // location.reload();
                  }}

                  className="primary-gradient h-9 w-44 rounded-lg text-base font-medium"
                >
                  Select
                </button>
              </div>
            </div>
          </DialogPanel>
        </div>
      </div>
    </Dialog>
  );
};

export default SelectThemeColorModal;
