import React, { useState } from "react";
import { Dialog, DialogPanel, DialogTitle } from "@headlessui/react";
import { RxCross2 } from "react-icons/rx";
import { useAppDispatch, useAppSelector } from "../../../utils/hooks";
import { updateViewState } from "../../../store/Slices/ViewManagerSlice";
import { FaCrown, FaGem, FaStar } from "react-icons/fa";
import { BsCheck2Circle } from "react-icons/bs";
import { useTheme } from "../../../context/ThemeProvider";
import Button from "../../../components/Button";

const SubscriptionModal: React.FC = () => {
  const dispatch = useAppDispatch();
  const { theme } = useTheme();
  const ViewManager = useAppSelector((state) => state.ViewManager);
  const [selectedPlan, setSelectedPlan] = useState<number>(6); // Default to 6 months

  const handleCloseModal = () => {
    dispatch(
      updateViewState({
        showSubscription: false,
      }),
    );
  };

  const subscriptionPlans = [
    {
      id: 3,
      name: "3 Months",
      icon: <FaStar className="text-yellow-400" />,
      pricePerMonth: 10,
      total: 30,
    },
    {
      id: 6,
      name: "6 Months",
      icon: <FaGem className="text-blue-500" />,
      pricePerMonth: 10,
      total: 60,
    },
    {
      id: 12,
      name: "12 Months",
      icon: <FaCrown className="text-purple-500" />,
      pricePerMonth: 10,
      total: 120,
    },
  ];

  const features = [
    "Automated Message when online and offline",
    "Schedule Meeting, Reminder Notification and redirect to whoxa call",
    "Audio Call",
    "Screen Share",
    "Audio Record",
    "Video Record",
    "Message translate",
    "Calendar view for scheduling meeting",
  ];

  const handlePurchase = () => {
    // Handle purchase logic here
    console.log("Purchasing plan:", selectedPlan, "months");
    // Add your purchase logic here
  };

  return (
    <Dialog
      open={ViewManager.showSubscription}
      onClose={handleCloseModal}
      className="relative z-50"
    >
      <div className="fixed inset-0 flex items-center justify-center bg-black/50 p-4 backdrop-blur-sm">
        <DialogPanel className="w-full max-w-md rounded-2xl bg-primary shadow-2xl ">
          {/* Header */}
          <div className="p-6 pb-4">
            <div className="mb-2 flex items-center justify-between">
              <div></div>
              <DialogTitle className="text-center text-xl font-semibold ">
                Subscription
              </DialogTitle>
              <button
                onClick={handleCloseModal}
                className="text-darkText p-1 -mr-2"
                aria-label="Close"
              >
                <RxCross2 className="h-5 w-5" />
              </button>
            </div>
            <p className="text-center text-sm ">
              This purchase can only be used on iOS system. Payment will be
              charged to your iTunes account at confirmation of purchase.
            </p>
          </div>

          {/* Features List */}
          <div className="max-h-56 overflow-y-auto px-6 py-4">
            <ul className="space-y-3">
              {features.map((feature, index) => (
                <li key={index} className="flex items-start">
                  {/* <BsCheck2Circle className="mr-3 mt-0.5 h-5 w-5 flex-shrink-0 text-green-500" /> */}
                  <img className="mr-3 mt-0.5 h-5 w-5 flex-shrink-0" src="/Home/subscription_tick.png" alt="" />
                  <span className="text-lightText">
                    {feature}
                  </span>
                </li>
              ))}
            </ul>
          </div>

          {/* Subscription Plans */}
          <div className="space-y-4 p-6 pt-0">
            <div className="grid gap-3">
              {subscriptionPlans.map((plan) => (
                <div
                  key={plan.id}
                  onClick={() => setSelectedPlan(plan.id)}
                  className={`relative cursor-pointer rounded-xl border-2 p-4 transition-all duration-200 ${
                    selectedPlan === plan.id
                      ? " border-[#FFCC4A] "
                      : " "
                  }`}
                >
                  <div className="flex items-center justify-between">
                    <div className="flex items-center">
                      <div className="mr-3 text-lightText">
                        {plan.icon}
                      </div>
                      <div>
                        <div className="font-medium ">
                          {plan.name}
                        </div>
                        <div className="text-sm text-lightText">
                          ${plan.pricePerMonth} Per Month
                        </div>
                      </div>
                    </div>
                    <div className="text-lg font-bold text-[#FCC604] ">
                      ${plan.total}.00
                    </div>
                  </div>
                </div>
              ))}
            </div>

            {/* Purchase Button */}
            {/* <button
              onClick={handlePurchase}
              className="w-full rounded-xl bg-gradient-to-r from-yellow-500 to-yellow-600 px-4 py-3 font-semibold text-white shadow-md transition-opacity hover:opacity-95 hover:shadow-lg focus:outline-none focus:ring-2 focus:ring-yellow-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800"
            >
              Purchase plan
            </button> */}
            <Button
              onClickFunc={handlePurchase}
              className="w-full"
              text="Purchase plan"
            />
          </div>
        </DialogPanel>
      </div>
    </Dialog>
  );
};

export default SubscriptionModal;
