import { NavLink, useLocation } from "react-router-dom";
import ThemeToggleButton from "./ThemeToggle";
import { useTheme } from "../../context/ThemeProvider";
import { useState } from "react";
import LogoutModal from "./Settings/LogOutModal";
// import { useAppDispatch } from "../../utils/hooks";
import { useWebsiteSettings } from "../../store/api/useWebsiteSettings";
import { useAppDispatch, useAppSelector } from "../../utils/hooks";
import { updateViewState } from "../../store/Slices/ViewManagerSlice";

export default function Sidebar() {
  const { theme } = useTheme();
  // const dispatch = useAppDispatch();
  const location = useLocation();
  const [showLogOutModal, setShowLogOutModal] = useState(false);
  const ViewManager = useAppSelector((state) => state.ViewManager)
  const { data: websiteSettings } = useWebsiteSettings();
  const dispatch = useAppDispatch()

  return (
    <>
      <div className="fixed hidden h-screen min-w-24 flex-col justify-between bg-primary py-10 text-darkText shadow-xl lg:flex 2xl:min-w-28">
        <div className="bgGradient flex flex-col items-center gap-7">
          <img
            src={`${theme === "dark" ? websiteSettings?.data.web_logo_dark : websiteSettings?.data.web_logo_light}`}
            className="mb-10 h-14 w-14 object-contain"
            alt=""
          />
          <NavLink to={"/profile"} className="cursor-pointer">
            {location.pathname === "/profile" ? (
              <svg width="27" height="27" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M5.15875 14.56C2.73875 16.18 2.73875 18.82 5.15875 20.43C7.90875 22.27 12.4188 22.27 15.1688 20.43C17.5888 18.81 17.5888 16.17 15.1688 14.56C12.4288 12.73 7.91875 12.73 5.15875 14.56Z" fill="url(#paint0_linear_6574_33876)" />
                <path d="M10.1586 10.87C10.0586 10.86 9.93859 10.86 9.82859 10.87C7.44859 10.79 5.55859 8.84 5.55859 6.44C5.55859 3.99 7.53859 2 9.99859 2C12.4486 2 14.4386 3.99 14.4386 6.44C14.4286 8.84 12.5386 10.79 10.1586 10.87Z" fill="url(#paint1_linear_6574_33876)" />
                <path d="M12.1586 10.87C12.0586 10.86 11.9386 10.86 11.8286 10.87C9.44859 10.79 7.55859 8.84 7.55859 6.44C7.55859 3.99 9.53859 2 11.9986 2C14.4486 2 16.4386 3.99 16.4386 6.44C16.4286 8.84 14.5386 10.79 12.1586 10.87Z" stroke={theme == "dark" ? "white" : "black"} stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M7.15875 14.56C4.73875 16.18 4.73875 18.82 7.15875 20.43C9.90875 22.27 14.4188 22.27 17.1688 20.43C19.5888 18.81 19.5888 16.17 17.1688 14.56C14.4288 12.73 9.91875 12.73 7.15875 14.56Z" stroke={theme == "dark" ? "white" : "black"} stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                <defs>
                  <linearGradient id="paint0_linear_6574_33876" x1="10.1638" y1="13.1875" x2="10.1638" y2="21.81" gradientUnits="userSpaceOnUse">
                    <stop stop-color="var(--theme-color)" />
                    <stop offset="1" stop-color="var(--theme-color)" />
                  </linearGradient>
                  <linearGradient id="paint1_linear_6574_33876" x1="9.99859" y1="2" x2="9.99859" y2="10.87" gradientUnits="userSpaceOnUse">
                    <stop stop-color="var(--theme-color)" />
                    <stop offset="1" stop-color="var(--theme-color)" />
                  </linearGradient>
                </defs>
              </svg>
            ) : (
              <img
                className="h-7"
                src={`${theme === "dark" ? "/DarkIcons" : "/LightIcons"
                  }/profile.png`}
                alt=""
              />
            )}
          </NavLink>
          <NavLink
            onClick={() => {
              // To clear the previous conversation messages
              if (location.pathname != "/chat") {
                // This was causing the unexpected issues ======================================================================
                // dispatch(removeMessageList());
              }
            }}
            to={"/chat"}
            className="cursor-pointer"
          >
            {location.pathname === "/chat" ? (
              // selected chat icon
              <svg
                className="h-7"
                xmlns="http://www.w3.org/2000/svg"
                viewBox="0 0 26 26"

              >
                <svg width="26" height="26" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M6.5 19H6C2 19 0 18 0 13V8C0 4 2 2 6 2H14C18 2 20 4 20 8V13C20 17 18 19 14 19H13.5C13.19 19 12.89 19.15 12.7 19.4L11.2 21.4C10.54 22.28 9.46 22.28 8.8 21.4L7.3 19.4C7.14 19.18 6.77 19 6.5 19Z" fill="var(--theme-color)" />
                  <path d="M8.5 19H8C4 19 2 18 2 13V8C2 4 4 2 8 2H16C20 2 22 4 22 8V13C22 17 20 19 16 19H15.5C15.19 19 14.89 19.15 14.7 19.4L13.2 21.4C12.54 22.28 11.46 22.28 10.8 21.4L9.3 19.4C9.14 19.18 8.77 19 8.5 19Z" stroke={theme === "dark" ? "white" : "black"} stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                  <path d="M7 8H17" stroke={theme === "dark" ? "white" : "black"} stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                  <path d="M7 13H13" stroke={theme === "dark" ? "white" : "black"} stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
              </svg>
            ) : (
              <img
                className="h-7"
                src={`${theme === "dark" ? "/DarkIcons" : "/LightIcons"
                  }/chat.png`}
                alt=""
              />
            )}
          </NavLink>
          {/* <NavLink
            onClick={() => {
              // To clear the previous conversation messages
              if (location.pathname != "/public-group") {
                // This was causing the unexpected issues ======================================================================
                // dispatch(removeMessageList());
              }
            }}
            to={"/public-group"}
            className="cursor-pointer"
          >
            {location.pathname === "/public-group" ? (
              <img
                className="h-7"
                src={`${
                  theme === "dark" ? "/DarkIcons" : "/LightIcons"
                }/public_group_selected.png`}
                // src="/LightIcons/chat_selected.png"
                alt=""
              />
            ) : (
              <img
                className="h-7"
                src={`${
                  theme === "dark" ? "/DarkIcons" : "/LightIcons"
                }/public_group.png`}
                alt=""
              />
            )}
          </NavLink> */}
          {/* <NavLink to={"/status"} className="cursor-pointer">
            {location.pathname === "/status" ? (
              <img
                className="h-7"
                src={`${
                  theme === "dark" ? "/DarkIcons" : "/LightIcons"
                }/status_selected.png`}
                alt=""
              />
            ) : (
              <img
                className="h-7"
                src={`${
                  theme === "dark" ? "/DarkIcons" : "/LightIcons"
                }/status.png`}
                alt=""
              />
            )}
          </NavLink> */}
          <NavLink to={"/contact-list"} className="cursor-pointer">
            {location.pathname === "/contact-list" ? (
              // selected contact list icon
              <svg width="27" height="27" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M15 22H5C1 22 0 21 0 17V9C0 5 1 4 5 4H15C19 4 20 5 20 9V17C20 21 19 22 15 22Z" fill="url(#paint0_linear_760_13388)" />
                <path d="M17 21H7C3 21 2 20 2 16V8C2 4 3 3 7 3H17C21 3 22 4 22 8V16C22 20 21 21 17 21Z" stroke={theme === "dark" ? "white" : "black"} stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M14 8H19" stroke={theme === "dark" ? "white" : "black"} stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M15 12H19" stroke={theme === "dark" ? "white" : "black"} stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M17 16H19" stroke={theme === "dark" ? "white" : "black"} stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M8.50141 11.2899C9.50104 11.2899 10.3114 10.4796 10.3114 9.47992C10.3114 8.48029 9.50104 7.66992 8.50141 7.66992C7.50177 7.66992 6.69141 8.48029 6.69141 9.47992C6.69141 10.4796 7.50177 11.2899 8.50141 11.2899Z" stroke={theme === "dark" ? "white" : "black"} stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M12 16.3298C11.86 14.8798 10.71 13.7398 9.26 13.6098C8.76 13.5598 8.25 13.5598 7.74 13.6098C6.29 13.7498 5.14 14.8798 5 16.3298" stroke={theme === "dark" ? "white" : "black"} stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                <defs>
                  <linearGradient id="paint0_linear_760_13388" x1="10" y1="4" x2="10" y2="22" gradientUnits="userSpaceOnUse">
                    <stop stop-color="var(--theme-color)" />
                    <stop offset="1" stop-color="var(--theme-color)" />
                  </linearGradient>
                </defs>
              </svg>
            ) : (
              <img
                className="h-7"
                src={`${theme === "dark" ? "/DarkIcons" : "/LightIcons"
                  }/contact.png`}
                alt=""
              />
            )}
          </NavLink>
          <NavLink to={"/status"} className="cursor-pointer">
            {location.pathname === "/status" ? (
              <svg width="26" height="26" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <circle cx="9.9" cy="12.9" r="9.9" fill="var(--theme-color)" />
                <path d="M2.44922 14.9697C3.51922 18.4097 6.39923 21.0597 9.97923 21.7897" stroke={theme === "dark" ? "white" : "black"} stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M2.05078 10.98C2.56078 5.93 6.82078 2 12.0008 2C17.1808 2 21.4408 5.94 21.9508 10.98" stroke={theme === "dark" ? "white" : "black"} stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M14.0117 21.7995C17.5817 21.0695 20.4517 18.4495 21.5417 15.0195" stroke={theme === "dark" ? "white" : "black"} stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
              </svg>
            ) : (
              <img
                className="h-7"
                src={`${theme === "dark" ? "/DarkIcons" : "/LightIcons"
                  }/status.png`}
                alt=""
              />
            )}
          </NavLink>
          <NavLink to={"/call-history"} className="cursor-pointer">
            {location.pathname === "/call-history" ? (
              <svg width="27" height="27" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M19.97 18.33C19.97 18.69 19.89 19.06 19.72 19.42C19.55 19.78 19.33 20.12 19.04 20.44C18.55 20.98 18.01 21.37 17.4 21.62C16.8 21.87 16.15 22 15.45 22C14.43 22 13.34 21.76 12.19 21.27C11.04 20.78 9.89 20.12 8.75 19.29C7.6 18.45 6.51 17.52 5.47 16.49C4.44 15.45 3.51 14.36 2.68 13.22C1.86 12.08 1.2 10.94 0.72 9.81C0.24 8.67 0 7.58 0 6.54C0 5.86 0.12 5.21 0.36 4.61C0.6 4 0.98 3.44 1.51 2.94C2.15 2.31 2.85 2 3.59 2C3.87 2 4.15 2.06 4.4 2.18C4.66 2.3 4.89 2.48 5.07 2.74L7.39 6.01C7.57 6.26 7.7 6.49 7.79 6.71C7.88 6.92 7.93 7.13 7.93 7.32C7.93 7.56 7.86 7.8 7.72 8.03C7.59 8.26 7.4 8.5 7.16 8.74L6.4 9.53C6.29 9.64 6.24 9.77 6.24 9.93C6.24 10.01 6.25 10.08 6.27 10.16C6.3 10.24 6.33 10.3 6.35 10.36C6.53 10.69 6.84 11.12 7.28 11.64C7.73 12.16 8.21 12.69 8.73 13.22C9.27 13.75 9.79 14.24 10.32 14.69C10.84 15.13 11.27 15.43 11.61 15.61C11.66 15.63 11.72 15.66 11.79 15.69C11.87 15.72 11.95 15.73 12.04 15.73C12.21 15.73 12.34 15.67 12.45 15.56L13.21 14.81C13.46 14.56 13.7 14.37 13.93 14.25C14.16 14.11 14.39 14.04 14.64 14.04C14.83 14.04 15.03 14.08 15.25 14.17C15.47 14.26 15.7 14.39 15.95 14.56L19.26 16.91C19.52 17.09 19.7 17.3 19.81 17.55C19.91 17.8 19.97 18.05 19.97 18.33Z" fill="url(#paint0_linear_760_13390)" />
                <path d="M22.97 18.33C22.97 18.69 22.89 19.06 22.72 19.42C22.55 19.78 22.33 20.12 22.04 20.44C21.55 20.98 21.01 21.37 20.4 21.62C19.8 21.87 19.15 22 18.45 22C17.43 22 16.34 21.76 15.19 21.27C14.04 20.78 12.89 20.12 11.75 19.29C10.6 18.45 9.51 17.52 8.47 16.49C7.44 15.45 6.51 14.36 5.68 13.22C4.86 12.08 4.2 10.94 3.72 9.81C3.24 8.67 3 7.58 3 6.54C3 5.86 3.12 5.21 3.36 4.61C3.6 4 3.98 3.44 4.51 2.94C5.15 2.31 5.85 2 6.59 2C6.87 2 7.15 2.06 7.4 2.18C7.66 2.3 7.89 2.48 8.07 2.74L10.39 6.01C10.57 6.26 10.7 6.49 10.79 6.71C10.88 6.92 10.93 7.13 10.93 7.32C10.93 7.56 10.86 7.8 10.72 8.03C10.59 8.26 10.4 8.5 10.16 8.74L9.4 9.53C9.29 9.64 9.24 9.77 9.24 9.93C9.24 10.01 9.25 10.08 9.27 10.16C9.3 10.24 9.33 10.3 9.35 10.36C9.53 10.69 9.84 11.12 10.28 11.64C10.73 12.16 11.21 12.69 11.73 13.22C12.27 13.75 12.79 14.24 13.32 14.69C13.84 15.13 14.27 15.43 14.61 15.61C14.66 15.63 14.72 15.66 14.79 15.69C14.87 15.72 14.95 15.73 15.04 15.73C15.21 15.73 15.34 15.67 15.45 15.56L16.21 14.81C16.46 14.56 16.7 14.37 16.93 14.25C17.16 14.11 17.39 14.04 17.64 14.04C17.83 14.04 18.03 14.08 18.25 14.17C18.47 14.26 18.7 14.39 18.95 14.56L22.26 16.91C22.52 17.09 22.7 17.3 22.81 17.55C22.91 17.8 22.97 18.05 22.97 18.33Z" stroke={theme == "dark" ? "white" : "black"} stroke-width="1.5" stroke-miterlimit="10" />
                <defs>
                  <linearGradient id="paint0_linear_760_13390" x1="9.985" y1="2" x2="9.985" y2="22" gradientUnits="userSpaceOnUse">
                    <stop stop-color="var(--theme-color)" />
                    <stop offset="1" stop-color="var(--theme-color)" />
                  </linearGradient>
                </defs>
              </svg>
            ) : (
              <img
                className="h-7"
                src={`${theme === "dark" ? "/DarkIcons" : "/LightIcons"
                  }/call.png`}
                alt=""
              />
            )}
          </NavLink>
          <NavLink to={"/setting"} className="cursor-pointer">
            {location.pathname === "/setting" ? (
              <svg width="27" height="27" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M1 10.1104V15.8804C1 18.0004 1 18.0004 3 19.3504L8.5 22.5304C9.33 23.0104 10.68 23.0104 11.5 22.5304L17 19.3504C19 18.0004 19 18.0004 19 15.8904V10.1104C19 8.00035 19 8.00035 17 6.65035L11.5 3.47035C10.68 2.99035 9.33 2.99035 8.5 3.47035L3 6.65035C1 8.00035 1 8.00035 1 10.1104Z" fill="var(--theme-color)" />
                <path d="M3 9.11035V14.8804C3 17.0004 3 17.0004 5 18.3504L10.5 21.5304C11.33 22.0104 12.68 22.0104 13.5 21.5304L19 18.3504C21 17.0004 21 17.0004 21 14.8904V9.11035C21 7.00035 21 7.00035 19 5.65035L13.5 2.47035C12.68 1.99035 11.33 1.99035 10.5 2.47035L5 5.65035C3 7.00035 3 7.00035 3 9.11035Z" stroke={theme == "dark" ? "white" : "black"} stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M12 15C13.6569 15 15 13.6569 15 12C15 10.3431 13.6569 9 12 9C10.3431 9 9 10.3431 9 12C9 13.6569 10.3431 15 12 15Z" stroke={theme == "dark" ? "white" : "black"} stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
              </svg>
            ) : (
              <img
                className="h-7"
                src={`${theme === "dark" ? "/DarkIcons" : "/LightIcons"
                  }/setting.png`}
                alt=""
              />
            )}
          </NavLink>
          <div onClick={() => {
            dispatch(
              updateViewState({
                show_notification_modal: true,
              }),
            );
          }} className="cursor-pointer">

            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M12.0186 2.91016C8.70862 2.91016 6.01862 5.60016 6.01862 8.91016V11.8002C6.01862 12.4102 5.75862 13.3402 5.44862 13.8602L4.29862 15.7702C3.58862 16.9502 4.07862 18.2602 5.37862 18.7002C9.68862 20.1402 14.3386 20.1402 18.6486 18.7002C19.8586 18.3002 20.3886 16.8702 19.7286 15.7702L18.5786 13.8602C18.2786 13.3402 18.0186 12.4102 18.0186 11.8002V8.91016C18.0186 5.61016 15.3186 2.91016 12.0186 2.91016Z" stroke={theme == "dark" ? "white" : "black"} stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" />
              <path d="M13.8719 3.20043C13.5619 3.11043 13.2419 3.04043 12.9119 3.00043C11.9519 2.88043 11.0319 2.95043 10.1719 3.20043C10.4619 2.46043 11.1819 1.94043 12.0219 1.94043C12.8619 1.94043 13.5819 2.46043 13.8719 3.20043Z" stroke={theme == "dark" ? "white" : "black"} stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
              <path d="M15.0195 19.0596C15.0195 20.7096 13.6695 22.0596 12.0195 22.0596C11.1995 22.0596 10.4395 21.7196 9.89953 21.1796C9.35953 20.6396 9.01953 19.8796 9.01953 19.0596" stroke={theme == "dark" ? "white" : "black"} stroke-width="1.5" stroke-miterlimit="10" />
            </svg>


          </div>
        </div>
        <div className="flex flex-col items-center gap-7">
          <ThemeToggleButton />
          <LogoutModal
            isOpen={showLogOutModal}
            setIsOpen={setShowLogOutModal}
          />
          <button
            onClick={() => {
              setShowLogOutModal(true);
            }}
          >
            <img
              className="h-7"
              src={`${theme === "dark" ? "/DarkIcons" : "/LightIcons"
                }/logout.png`}
              alt=""
            />
          </button>
        </div>
      </div>
      <div className="hidden min-w-24 lg:flex 2xl:min-w-28"></div>
    </>
  );
}
