import StatusProfile from "./StatusProfile";
import { formatRelativeTime } from "../../../utils/formatUTCtoLocalDate";
import { useAppSelector } from "../../../utils/hooks";
import SearchNotFoundAnimation from "../../../components/SearchNotFoundAnimation";

export default function NotViewedStatusList() {
  const statusData = useAppSelector((state) => state.status);
  const userData = useAppSelector((state) => state.userData);
  return (
    <>
      <div className="my-3 flex w-full flex-col overflow-y-auto overflow-x-hidden px-4">
        {statusData?.data?.recent_stories?.filter((item) => item.user_id !== userData.user_id).length == 0 ? (
          <div className="grid h-96 place-content-center text-center gap-5">
            {/* <img
              className="mx-auto h-16 w-16"
              src="/LightIcons/no_search_result_found.png"
              alt=""
            /> */}
            <SearchNotFoundAnimation />

            <div>No Status Found</div>
          </div>
        ) : (
          statusData?.data?.recent_stories?.filter((item) => item.user_id !== userData.user_id).map((item, idx) => (
            <>
              <StatusProfile
                currentStatusId={item.stories[0].story_id}
                name={item.full_name}
                profile_url={item.profile_pic}
                time={formatRelativeTime(item.updatedAt)}
                classes="border-[var(--theme-color)]"
              />
              <hr className="border-t border-borderColor" />
            </>
          ))
        )}
      </div>
    </>
  );
}
