import { useAppDispatch, useAppSelector } from "../../../utils/hooks";
import { useStream } from "../../../context/StreamProvider";
import { socketInstance } from "../../../socket/socket";
import { usePeer } from "../../../hooks/usePeer";
import { LuUsers } from "react-icons/lu";
import { updateViewState } from "../../../store/Slices/ViewManagerSlice";
import { RxCross1 } from "react-icons/rx";
import { useWebsiteSettings } from "../../../store/api/useWebsiteSettings";
import { useTheme } from "../../../context/ThemeProvider";

export default function CallHeader() {
  const dispatch = useAppDispatch();
  const socket = socketInstance();
  const { call_id, chat_id } = useAppSelector((state) => state.PeerJsSlice);
  const { data: websiteSettings } = useWebsiteSettings();
  const { theme } = useTheme();
  const { myPeer } = usePeer();
  const Viewmanager = useAppSelector((state) => state.ViewManager);
  function endCall() {
    socket.emit("leave_call", {
      call_id: call_id,
      peer_id: myPeer?.current?.id,
      call_type: "video",
      chat_id: chat_id,
    });
    sessionStorage.removeItem("callStartTime");
    window.location.replace("/chat");
  }

  return (
    <div className="flex h-16 w-full items-center justify-between bg-themeColor px-4 lg:px-8">
      <img
        src={theme === "dark" ? websiteSettings?.data.web_logo_dark : websiteSettings?.data.web_logo_light}
        className="h-16 w-40 object-contain"
        alt=""
      />

      {Viewmanager.show_chat_in_call ? (
        <div
          onClick={() => {
            dispatch(updateViewState({ show_chat_in_call: false }));
          }}
          className="rounded-full cursor-pointer bg-black bg-opacity-25 p-2 lg:hidden"
        >
          <RxCross1 className="text-xl" />
        </div>
      ) : (
        <div
          onClick={() => {
            dispatch(updateViewState({ show_chat_in_call: true }));
          }}
          className="rounded-full cursor-pointer bg-black bg-opacity-25 p-2 lg:hidden"
        >
          <LuUsers className="text-xl" />
        </div>
      )}

      <div
        onClick={endCall}
        className="hidden cursor-pointer rounded-full bg-[#FA4343] px-4 py-1 text-white lg:block"
      >
        End Call
      </div>
    </div>
  );
}
