import { Route, Routes, useLocation, useNavigate } from "react-router-dom";
import PageNotFound from "./PageNotFound";
import Login from "./Register/Login";
import EnterOtp from "./Register/EnterOtp";
import Chat from "./Home/Chat/Chat";
import Home from "./Home/Home";
import { useEffect } from "react";
import Profile from "./Home/Profile/Profile";
import Setting from "./Home/Settings/Settings";
import ImageViewer from "../components/ImageViewer";
import ListenAllEvents from "../socket/ListenAllEvents";
import { useUserProfile } from "../store/api/useUserProfile";
import Contacts from "./Home/Contacts/Contacts";
import CreateGroup from "./Home/Group/CreateGroup";
import AddMemberToGroup from "./Home/Group/AddMemberToGroup";
import AddMemberModal from "./Home/GroupInfo/AddMemberModal";
import ForwardMessageModal from "./Home/MessageList/SelectedMessageOption/ForwardMessageModal";
import StarMessage from "./Home/StarMessage/StarMessage";
import NavigateToSpesificMessage from "../utils/NavigateToSpesificMessage";
import SelectAboutModal from "./Home/Settings/SelectAboutModal";
import UserDetails from "./Register/UserDetails";
import SelectProfilePic from "./Home/Profile/SelectProfilePic";
import ChangeProfileImageModal from "./Home/Profile/ChangeProfileImageModal";
import LoadInitialData from "../components/LoadInitialData";
import ReportUserModal from "./Home/ReportUser/ReportUserModal";
import { changeFavicon, changeThemeColor } from "../utils/changeFavicon";
import { useWebsiteSettings } from "../store/api/useWebsiteSettings";
import { Helmet } from "react-helmet";
import PrivacyPolicyDrawer from "./Home/Settings/PrivacyPolicyDrawer";
import { useAppSelector } from "../utils/hooks";
import Cookies from "js-cookie";
import AdminBlockedYou from "../components/AdminBlockedYou";

import { useFetchLanguageTextList } from "../store/api/useFetchLanguageTextList";
import SelectLanguageModal from "./Home/Settings/SelectLanguageModal";
import { useFetchLanguageList } from "../store/api/useFetchLanguageList";
import PrivacyPolicyPage from "./Home/Settings/PrivacyPolicyPage";
import VideoCall from "./Home/VideoCall/VideoCall";
import PinMessageModal from "./Home/MessageList/SelectedMessageOption/PinMessageModal";
import CreatePollModal from "./Home/MessageList/SendMessage/CreatePollModal";
import ViewPollVoteModal from "./Home/MessageList/SendMessage/ViewPollVoteModal";
import PublicGroup from "./Home/PublicGroups/PublicGroup";
import SendLocationModal from "./Home/Location/SendLocationModal";
import AcceptVideoCall from "./Home/VideoCall/AcceptVideoCall";
import CallDeclinedModal from "./Home/VideoCall/CallDeclinedModal";
import CallHIstory from "./Home/CallHistory/CallHIstory";
import { useContactList } from "../store/api/useContactList";
import GiphyComponentModal from "./Home/MessageList/SendMessage/GiphyComponentModal";
import { useTheme } from "../context/ThemeProvider";
import SelectThemeColorModal from "./Home/Settings/SelectThemeColorModal";
import StatusModal from "./Home/Status/StatusModal/StatusModal";
import StatusList from "./Home/Status/StatusList";
import { getContrastTextColor } from "../utils/themeColors";
import NotificationModal from "./Home/Notification/NotificationModal";
const AppRoutes = () => {
  const pathname = useLocation().pathname;
  const navigate = useNavigate();
  const { data: websiteSettings } = useWebsiteSettings();
  const userData = useAppSelector((state) => state.userData);
  const { data } = useFetchLanguageTextList();
  const { data: languageListRes } = useFetchLanguageList();
  const chatList = useAppSelector((state) => state.chatList);
  const { theme } = useTheme();

  // fetch the saved contact list
  useContactList();

  useEffect(() => {
    // check if the user selected language is support rtl or not =========================================================
    languageListRes?.data?.Records.filter(
      (language) => language.language_alignment == "RTL",
    ).map((e) => {
      const temp_language_id = Cookies.get("language_id");
      if (e.language_id == Number(temp_language_id)) {
        document.getElementsByTagName("html")[0].setAttribute("dir", "rtl");
      }
    });
  }, [languageListRes]);

  useEffect(() => {
    if (pathname == "/") {
      navigate("/chat");
    }
  }, [pathname]);
  useUserProfile();

  // To Set the favicon ==================================================================================
  useEffect(() => {
    if (!websiteSettings?.data) {
      return;
    }
    changeFavicon(websiteSettings?.data.web_logo_light);
    changeThemeColor(
      theme === "dark"
        ? "#252525"
        : "#fafafa",
    );
    const themeColor = Cookies.get("theme_color");
    if (!themeColor) {
      const text_color = getContrastTextColor(websiteSettings?.data?.app_primary_color || "#FCC604");
      Cookies.set("theme_color", websiteSettings?.data?.app_primary_color || "#FCC604");
      Cookies.set("theme_text_color", text_color);
      document.documentElement.style.setProperty("--theme-color", websiteSettings?.data?.app_primary_color || "#FCC604");
      document.documentElement.style.setProperty("--theme-text-color", text_color);
    }
  }, [websiteSettings, theme]);

  return (
    <>
      {userData.bloked_by_admin ? (
        <AdminBlockedYou />
      ) : (
        <>
          <div className="">
            <Helmet>
              <title>
                {websiteSettings?.data ? websiteSettings.data.app_name : ""}
              </title>
            </Helmet>
            <LoadInitialData />
            <ListenAllEvents />
            <ImageViewer />
            <AddMemberModal />
            <ForwardMessageModal />
            <PinMessageModal />
            <SelectAboutModal />
            <NavigateToSpesificMessage />
            <ChangeProfileImageModal />
            <ReportUserModal />
            <PrivacyPolicyDrawer />
            <SelectLanguageModal />
            <CreatePollModal />
            <ViewPollVoteModal />
            <SendLocationModal />
            <AcceptVideoCall />
            <CallDeclinedModal />
            <GiphyComponentModal />
            <SelectThemeColorModal />
            <StatusModal />
            <NotificationModal />
            <Routes>
              {/* <Route path="/" element={<Chat />} /> */}

              <Route path="/" element={<Home />}>
                <Route path="profile" element={<Profile />} />
                <Route path="chat" element={<Chat />} />
                <Route path="/public-group" element={<PublicGroup />} />
                <Route path="status" element={<StatusList />} />

                <Route
                  path="add-member-to-group"
                  element={<AddMemberToGroup />}
                />
                <Route path="contact-list" element={<Contacts />} />
                <Route path="setting" element={<Setting />} />
                <Route path="call-history" element={<CallHIstory />} />
                <Route path="star-messages" element={<StarMessage />} />
                <Route path="create-group" element={<CreateGroup />} />
              </Route>
              <Route path="video-call" element={<VideoCall />} />
              <Route path="privacy-policy" element={<PrivacyPolicyPage />} />
              <Route path="/login" element={<Login />} />
              <Route path="/user-details" element={<UserDetails />} />
              <Route path="/select-profile" element={<SelectProfilePic />} />
              <Route path="/otp-verification" element={<EnterOtp />} />

              <Route path="*" element={<PageNotFound />} />
            </Routes>
            {/* <SignInModal /> */}
          </div>
        </>
      )}
    </>
  );
};

export default AppRoutes;
