import { createSlice, PayloadAction } from "@reduxjs/toolkit";
import { SendMessageData } from "../../types/SendMessageType";

const initialState: SendMessageData = {
  chat_id: 0,
  audio_time: "",
  forward_id: 0,
  latitude: "",
  longitude: "",
  message: "",
  message_type: "",
  mobile_num: "",
  reply_to: 0,
  status_id: 0,
  url: "",
  thumbnail_url: "",
  video_time: "",
  showEmojiPicker: false,
  showGiphyPicker: false,
  showAttachmentOptions: false,
  fileName: "",
};

// Create a slice of the state
const SendMessageSlice = createSlice({
  name: "SendMessageData",
  initialState,
  reducers: {
    // Reducer to update the MessageList
    updateSendMessageData(
      state,
      action: PayloadAction<Partial<SendMessageData>>,
    ) {
      return { ...state, ...action.payload };
    },
  },
});

// Export the reducer and actions
export default SendMessageSlice.reducer;
export const { updateSendMessageData } = SendMessageSlice.actions;
