import { useQuery } from "react-query";
import axios from "axios";
import { MediaDocLinksRes } from "../../types/ResType";
import { useAppSelector } from "../../utils/hooks";
import Cookies from "js-cookie";

export const useConversationMedia = () => {
  const currentConversationData = useAppSelector(
    (state) => state.CurrentConversation,
  );

  const token = Cookies.get("whoxa_web_token");

  return useQuery<MediaDocLinksRes, Error>(
    ["media", currentConversationData.chat_id],
    async () => {
      const response = await axios.post<MediaDocLinksRes>(
        `${import.meta.env.VITE_API_URL}chat/chat-media`,
        {
          chat_id: currentConversationData.chat_id,
          message_type: "media",
          pageSize: 1000,
        },
        {
          headers: {
            Authorization: `Bearer ${token}`,
          },
        },
      );

      return response.data;
    },
    {
      // Set cache time to prevent re-fetching on route changes
      staleTime: Infinity, // Data will never be considered stale
      cacheTime: Infinity, // Data will never be removed from cache
      enabled: currentConversationData.chat_id > 0,
    },
  );
};
