import { useQuery } from "react-query";
import axios from "axios";
import Cookies from "js-cookie";
import { NotificationlistRes } from "../../types/ResType";

export const useNotificationList = () => {
  const token = Cookies.get("whoxa_web_token");

  return useQuery<NotificationlistRes, Error>(
    ["users/list-broadcast-notification"],
    async () => {
      const response = await axios.post<NotificationlistRes>(
        `${import.meta.env.VITE_API_URL}users/list-broadcast-notification`,
        {},
        {
          headers: {
            Authorization: `Bearer ${token}`,
          },
        },
      );

      return response.data;
    },
    {
      // Set cache time to prevent re-fetching on route changes
      staleTime: Infinity, // Data will never be considered stale
      cacheTime: Infinity, // Data will never be removed from cache
    },
  );
};