import { useQuery } from "react-query";
import axios from "axios";
import { SearchChatListRes } from "../../types/SearchChatListType";
import Cookies from "js-cookie";

export const useSearchChatList = (searchText: string) => {
  const token = Cookies.get("whoxa_web_token");

  return useQuery<SearchChatListRes, Error>(
    ["chat/search-chat", searchText],
    async () => {
      const response = await axios.post<SearchChatListRes>(
        `${import.meta.env.VITE_API_URL}chat/search-chat`,
        { searchText },
        {
          headers: {
            Authorization: `Bearer ${token}`,
          },
        },
      );

      return response.data;
    },
    {
      // Set cache time to prevent re-fetching on route changes
      staleTime: Infinity, // Data will never be considered stale
      cacheTime: Infinity, // Data will never be removed from cache
    },
  );
};
