import { useQuery } from "react-query";
import axios from "axios";
import Cookies from "js-cookie";
import { StoryDetailsRes } from "../../types/StatusTypes";
import { useAppSelector } from "../../utils/hooks";

export const useStatusDetails = () => {
  const token = Cookies.get("whoxa_web_token");
  const story_id = useAppSelector((state) => state.ViewManager.currentStatusId);

  return useQuery<StoryDetailsRes, Error>(
    ["story/get-story", story_id],
    async () => {
      const response = await axios.post<StoryDetailsRes>(
        `${import.meta.env.VITE_API_URL}story/get-story`,
        {
          story_id,
        },
        {
          headers: {
            Authorization: `Bearer ${token}`,
          },
        },
      );
      return response.data;
    },
    {
      // Set cache time to prevent re-fetching on route changes
      staleTime: Infinity, // Data will never be considered stale
      cacheTime: Infinity, // Data will never be removed from cache
    },
  );
};
